/*
 * Decompiled with CFR 0.152.
 */
package com.zhipu.oapi.service.v4.api;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.zhipu.oapi.service.v4.api.ChatApi;
import com.zhipu.oapi.service.v4.embedding.EmbeddingRequest;
import com.zhipu.oapi.service.v4.embedding.EmbeddingResult;
import com.zhipu.oapi.service.v4.file.QueryFileResult;
import com.zhipu.oapi.service.v4.file.QueryFilesRequest;
import com.zhipu.oapi.service.v4.fine_turning.FineTuningEvent;
import com.zhipu.oapi.service.v4.fine_turning.FineTuningJob;
import com.zhipu.oapi.service.v4.fine_turning.FineTuningJobRequest;
import com.zhipu.oapi.service.v4.fine_turning.PersonalFineTuningJob;
import com.zhipu.oapi.service.v4.image.ImageResult;
import com.zhipu.oapi.service.v4.model.AuthenticationInterceptor;
import com.zhipu.oapi.service.v4.model.ChatCompletionAsyncResult;
import com.zhipu.oapi.service.v4.model.ChatCompletionRequest;
import com.zhipu.oapi.service.v4.model.ChatCompletionRequestMixIn;
import com.zhipu.oapi.service.v4.model.ChatCompletionResult;
import com.zhipu.oapi.service.v4.model.ChatFunction;
import com.zhipu.oapi.service.v4.model.ChatFunctionCall;
import com.zhipu.oapi.service.v4.model.ChatFunctionCallMixIn;
import com.zhipu.oapi.service.v4.model.ChatFunctionMixIn;
import com.zhipu.oapi.service.v4.model.ChatMessageAccumulator;
import com.zhipu.oapi.service.v4.model.ModelData;
import com.zhipu.oapi.service.v4.model.ResponseBodyCallback;
import com.zhipu.oapi.service.v4.model.SSE;
import com.zhipu.oapi.service.v4.model.ZhiPuAiError;
import com.zhipu.oapi.service.v4.model.ZhiPuAiHttpException;
import io.reactivex.BackpressureStrategy;
import io.reactivex.Flowable;
import io.reactivex.FlowableEmitter;
import io.reactivex.Single;
import java.io.File;
import java.io.IOException;
import java.time.Duration;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import okhttp3.ConnectionPool;
import okhttp3.Interceptor;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.OkHttpClient;
import okhttp3.RequestBody;
import okhttp3.ResponseBody;
import retrofit2.Call;
import retrofit2.CallAdapter;
import retrofit2.Callback;
import retrofit2.Converter;
import retrofit2.Retrofit;
import retrofit2.adapter.rxjava2.HttpException;
import retrofit2.adapter.rxjava2.RxJava2CallAdapterFactory;
import retrofit2.converter.jackson.JacksonConverterFactory;

public class ChatApiService {
    private static final String BASE_URL = "https://open.bigmodel.cn/";
    private static final Duration DEFAULT_TIMEOUT = Duration.ofSeconds(300L);
    private static final ObjectMapper mapper = ChatApiService.defaultObjectMapper();
    private final ChatApi api;
    private final ExecutorService executorService;

    public ChatApiService(String token) {
        this(token, DEFAULT_TIMEOUT);
    }

    public ChatApiService(String token, Duration timeout) {
        ObjectMapper mapper = ChatApiService.defaultObjectMapper();
        OkHttpClient client = ChatApiService.defaultClient(token, timeout);
        Retrofit retrofit = ChatApiService.defaultRetrofit(client, mapper);
        this.api = (ChatApi)retrofit.create(ChatApi.class);
        this.executorService = client.dispatcher().executorService();
    }

    public static <T> T execute(Single<T> apiCall) {
        try {
            return (T)apiCall.blockingGet();
        }
        catch (HttpException e) {
            try {
                if (e.response() == null || e.response().errorBody() == null) {
                    throw e;
                }
                String errorBody = e.response().errorBody().string();
                ZhiPuAiError error = (ZhiPuAiError)mapper.readValue(errorBody, ZhiPuAiError.class);
                String message = error.getError().getMessage();
                message = message + "&" + error.getError().getCode() + "&" + e.code();
                error.getError().setMessage(message);
                throw new ZhiPuAiHttpException(error, (Exception)((Object)e), e.code());
            }
            catch (IOException ex) {
                throw e;
            }
        }
    }

    public Flowable<ModelData> streamChatCompletion(Map<String, Object> request) {
        return this.stream(this.api.createChatCompletionStream(request), ModelData.class);
    }

    public ChatCompletionAsyncResult createChatCompletionAsync(Map<String, Object> request) {
        return ChatApiService.execute(this.api.createChatCompletionAsync(request));
    }

    public ChatCompletionResult createChatCompletion(Map<String, Object> request) {
        return ChatApiService.execute(this.api.createChatCompletion(request));
    }

    public EmbeddingResult createEmbeddings(EmbeddingRequest request) {
        return ChatApiService.execute(this.api.createEmbeddings(request));
    }

    public QueryFileResult queryFileList(QueryFilesRequest queryFilesRequest) {
        return ChatApiService.execute(this.api.queryFileList(queryFilesRequest.getAfter(), queryFilesRequest.getPurpose(), queryFilesRequest.getOrder(), queryFilesRequest.getLimit()));
    }

    public FineTuningEvent listFineTuningJobEvents(String fineTuningJobId, Integer limit, String after) {
        return ChatApiService.execute(this.api.listFineTuningJobEvents(fineTuningJobId, limit, after));
    }

    public FineTuningJob retrieveFineTuningJob(String fineTuningJobId, Integer limit, String after) {
        return ChatApiService.execute(this.api.retrieveFineTuningJob(fineTuningJobId, limit, after));
    }

    public PersonalFineTuningJob queryPersonalFineTuningJobs(Integer limit, String after) {
        return ChatApiService.execute(this.api.queryPersonalFineTuningJobs(limit, after));
    }

    public ChatCompletionResult queryAsyncResult(String id) {
        return ChatApiService.execute(this.api.queryAsyncResult(id));
    }

    public com.zhipu.oapi.service.v4.file.File uploadFile(String purpose, String filepath) {
        File file = new File(filepath);
        MultipartBody.Part filePart = MultipartBody.Part.createFormData((String)"file", (String)file.getName(), (RequestBody)RequestBody.create((MediaType)MediaType.parse((String)"application/octet-stream"), (File)file));
        MultipartBody.Builder formBodyBuilder = new MultipartBody.Builder().setType(MultipartBody.FORM);
        formBodyBuilder.addPart(filePart);
        formBodyBuilder.addFormDataPart("purpose", purpose);
        MultipartBody multipartBody = formBodyBuilder.build();
        return ChatApiService.execute(this.api.uploadFile(multipartBody));
    }

    public ImageResult createImage(Map<String, Object> request) {
        return ChatApiService.execute(this.api.createImage(request));
    }

    public FineTuningJob createFineTuningJob(FineTuningJobRequest request) {
        return ChatApiService.execute(this.api.createFineTuningJob(request));
    }

    private Flowable<ModelData> stream(Call<ResponseBody> apiCall, Class<ModelData> cl) {
        return ChatApiService.stream(apiCall).map(sse -> (ModelData)mapper.readValue(sse.getData(), cl));
    }

    public static Flowable<SSE> stream(Call<ResponseBody> apiCall) {
        return ChatApiService.stream(apiCall, false);
    }

    public static Flowable<SSE> stream(Call<ResponseBody> apiCall, boolean emitDone) {
        return Flowable.create(emitter -> apiCall.enqueue((Callback)new ResponseBodyCallback((FlowableEmitter<SSE>)emitter, emitDone)), (BackpressureStrategy)BackpressureStrategy.BUFFER);
    }

    public ChatApiService(ChatApi api) {
        this.api = api;
        this.executorService = null;
    }

    public ChatApiService(ChatApi api, ExecutorService executorService) {
        this.api = api;
        this.executorService = executorService;
    }

    public static ObjectMapper defaultObjectMapper() {
        ObjectMapper mapper = new ObjectMapper();
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        mapper.setPropertyNamingStrategy(PropertyNamingStrategy.SNAKE_CASE);
        mapper.addMixIn(ChatFunction.class, ChatFunctionMixIn.class);
        mapper.addMixIn(ChatCompletionRequest.class, ChatCompletionRequestMixIn.class);
        mapper.addMixIn(ChatFunctionCall.class, ChatFunctionCallMixIn.class);
        return mapper;
    }

    public static OkHttpClient defaultClient(String token, Duration timeout) {
        return new OkHttpClient.Builder().addInterceptor((Interceptor)new AuthenticationInterceptor(token)).connectionPool(new ConnectionPool(5, 1L, TimeUnit.SECONDS)).readTimeout(timeout.toMillis(), TimeUnit.MILLISECONDS).build();
    }

    public static Retrofit defaultRetrofit(OkHttpClient client, ObjectMapper mapper) {
        return new Retrofit.Builder().baseUrl(BASE_URL).client(client).addConverterFactory((Converter.Factory)JacksonConverterFactory.create((ObjectMapper)mapper)).addCallAdapterFactory((CallAdapter.Factory)RxJava2CallAdapterFactory.create()).build();
    }

    public Flowable<ChatMessageAccumulator> mapStreamToAccumulator(Flowable<ModelData> flowable) {
        return flowable.map(chunk -> new ChatMessageAccumulator(chunk.getChoices().get(0).getDelta(), null, chunk.getChoices().get(0), chunk.getUsage(), chunk.getCreated(), chunk.getId()));
    }
}

