/*
 * Decompiled with CFR 0.152.
 */
package com.zhipu.oapi.demo;

import com.alibaba.fastjson.JSON;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.zhipu.oapi.ClientV4;
import com.zhipu.oapi.service.v4.embedding.EmbeddingApiResponse;
import com.zhipu.oapi.service.v4.embedding.EmbeddingRequest;
import com.zhipu.oapi.service.v4.file.FileApiResponse;
import com.zhipu.oapi.service.v4.file.QueryFileApiResponse;
import com.zhipu.oapi.service.v4.file.QueryFilesRequest;
import com.zhipu.oapi.service.v4.fine_turning.CreateFineTuningJobApiResponse;
import com.zhipu.oapi.service.v4.fine_turning.FineTuningJobRequest;
import com.zhipu.oapi.service.v4.fine_turning.QueryFineTuningEventApiResponse;
import com.zhipu.oapi.service.v4.fine_turning.QueryFineTuningJobApiResponse;
import com.zhipu.oapi.service.v4.fine_turning.QueryFineTuningJobRequest;
import com.zhipu.oapi.service.v4.fine_turning.QueryPersonalFineTuningJobApiResponse;
import com.zhipu.oapi.service.v4.fine_turning.QueryPersonalFineTuningJobRequest;
import com.zhipu.oapi.service.v4.image.CreateImageRequest;
import com.zhipu.oapi.service.v4.image.ImageApiResponse;
import com.zhipu.oapi.service.v4.model.ChatCompletionRequest;
import com.zhipu.oapi.service.v4.model.ChatCompletionRequestMixIn;
import com.zhipu.oapi.service.v4.model.ChatFunction;
import com.zhipu.oapi.service.v4.model.ChatFunctionCall;
import com.zhipu.oapi.service.v4.model.ChatFunctionCallMixIn;
import com.zhipu.oapi.service.v4.model.ChatFunctionMixIn;
import com.zhipu.oapi.service.v4.model.ChatFunctionParameters;
import com.zhipu.oapi.service.v4.model.ChatMessage;
import com.zhipu.oapi.service.v4.model.ChatMessageAccumulator;
import com.zhipu.oapi.service.v4.model.ChatMessageRole;
import com.zhipu.oapi.service.v4.model.ChatTool;
import com.zhipu.oapi.service.v4.model.ChatToolType;
import com.zhipu.oapi.service.v4.model.Choice;
import com.zhipu.oapi.service.v4.model.ModelApiResponse;
import com.zhipu.oapi.service.v4.model.ModelData;
import com.zhipu.oapi.service.v4.model.QueryModelResultRequest;
import com.zhipu.oapi.service.v4.model.QueryModelResultResponse;
import io.reactivex.Flowable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.concurrent.atomic.AtomicBoolean;

public class V4OkHttpClientTest {
    private static final String API_KEY = "";
    private static final ClientV4 client = new ClientV4.Builder("").build();
    private static final ObjectMapper mapper = V4OkHttpClientTest.defaultObjectMapper();
    private static final String requestIdTemplate = "mycompany-%d";

    public static ObjectMapper defaultObjectMapper() {
        ObjectMapper mapper = new ObjectMapper();
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        mapper.setPropertyNamingStrategy(PropertyNamingStrategy.SNAKE_CASE);
        mapper.addMixIn(ChatFunction.class, ChatFunctionMixIn.class);
        mapper.addMixIn(ChatCompletionRequest.class, ChatCompletionRequestMixIn.class);
        mapper.addMixIn(ChatFunctionCall.class, ChatFunctionCallMixIn.class);
        return mapper;
    }

    public static void main(String[] args) throws Exception {
        System.setProperty("org.slf4j.simpleLogger.logFile", "System.out");
        V4OkHttpClientTest.testSseInvoke();
    }

    private static void testQueryPersonalFineTuningJobs() {
        QueryPersonalFineTuningJobRequest queryPersonalFineTuningJobRequest = new QueryPersonalFineTuningJobRequest();
        queryPersonalFineTuningJobRequest.setLimit(1);
        QueryPersonalFineTuningJobApiResponse queryPersonalFineTuningJobApiResponse = client.queryPersonalFineTuningJobs(queryPersonalFineTuningJobRequest);
        System.out.println("model output:" + JSON.toJSONString((Object)queryPersonalFineTuningJobApiResponse));
    }

    private static void testQueryFineTuningJobsEvents() {
        QueryFineTuningJobRequest queryFineTuningJobRequest = new QueryFineTuningJobRequest();
        queryFineTuningJobRequest.setJobId("ftjob-20240119114544390-zkgjb");
        QueryFineTuningEventApiResponse queryFineTuningEventApiResponse = client.queryFineTuningJobsEvents(queryFineTuningJobRequest);
        System.out.println("model output:" + JSON.toJSONString((Object)queryFineTuningEventApiResponse));
    }

    private static void testRetrieveFineTuningJobs() {
        QueryFineTuningJobRequest queryFineTuningJobRequest = new QueryFineTuningJobRequest();
        queryFineTuningJobRequest.setJobId("ftjob-20240119114544390-zkgjb");
        QueryFineTuningJobApiResponse queryFineTuningJobApiResponse = client.retrieveFineTuningJobs(queryFineTuningJobRequest);
        System.out.println("model output:" + JSON.toJSONString((Object)queryFineTuningJobApiResponse));
    }

    private static void testCreateFineTuningJob() {
        FineTuningJobRequest request = new FineTuningJobRequest();
        String requestId = String.format(requestIdTemplate, System.currentTimeMillis());
        request.setRequestId(requestId);
        request.setModel("chatglm3-6b");
        request.setTraining_file("file-20240118082608327-kp8qr");
        CreateFineTuningJobApiResponse createFineTuningJobApiResponse = client.createFineTuningJob(request);
        System.out.println("model output:" + JSON.toJSONString((Object)createFineTuningJobApiResponse));
    }

    private static void testQueryUploadFileList() {
        QueryFilesRequest queryFilesRequest = new QueryFilesRequest();
        QueryFileApiResponse queryFileApiResponse = client.queryFilesApi(queryFilesRequest);
        System.out.println("model output:" + JSON.toJSONString((Object)queryFileApiResponse));
    }

    private static void testUploadFile() {
        String filePath = "/Users/wujianguo/Downloads/transaction-data.jsonl";
        String purpose = "fine-tune";
        FileApiResponse fileApiResponse = client.invokeUploadFileApi(purpose, filePath);
        System.out.println("model output:" + JSON.toJSONString((Object)fileApiResponse));
    }

    private static void testEmbeddings() {
        EmbeddingRequest embeddingRequest = new EmbeddingRequest();
        embeddingRequest.setInput("hello world");
        embeddingRequest.setModel("embedding-2");
        EmbeddingApiResponse apiResponse = client.invokeEmbeddingsApi(embeddingRequest);
        System.out.println("model output:" + JSON.toJSONString((Object)apiResponse));
    }

    private static void testImageToWord() {
        ArrayList<ChatMessage> messages = new ArrayList<ChatMessage>();
        ArrayList contentList = new ArrayList();
        HashMap<String, String> textMap = new HashMap<String, String>();
        textMap.put("type", "text");
        textMap.put("text", "\u56fe\u91cc\u6709\u4ec0\u4e48");
        HashMap<String, Object> typeMap = new HashMap<String, Object>();
        typeMap.put("type", "image_url");
        HashMap<String, String> urlMap = new HashMap<String, String>();
        urlMap.put("url", "https://sfile.chatglm.cn/testpath/275ae5b6-5390-51ca-a81a-60332d1a7cac_0.png");
        typeMap.put("image_url", urlMap);
        contentList.add(textMap);
        contentList.add(typeMap);
        ChatMessage chatMessage = new ChatMessage(ChatMessageRole.USER.value(), contentList);
        messages.add(chatMessage);
        String requestId = String.format(requestIdTemplate, System.currentTimeMillis());
        ChatCompletionRequest chatCompletionRequest = ChatCompletionRequest.builder().model("glm-4v").stream(Boolean.FALSE).invokeMethod("invoke").messages(messages).requestId(requestId).build();
        ModelApiResponse modelApiResponse = client.invokeModelApi(chatCompletionRequest);
        System.out.println("model output:" + JSON.toJSONString((Object)modelApiResponse));
    }

    private static void testCreateImage() {
        CreateImageRequest createImageRequest = new CreateImageRequest();
        createImageRequest.setModel("cogview");
        ImageApiResponse imageApiResponse = client.createImage(createImageRequest);
        System.out.println("imageApiResponse:" + JSON.toJSONString((Object)imageApiResponse));
    }

    private static void testSseInvoke() {
        ArrayList<ChatMessage> messages = new ArrayList<ChatMessage>();
        ChatMessage chatMessage = new ChatMessage(ChatMessageRole.USER.value(), "ChatGLM\u548c\u4f60\u54ea\u4e2a\u66f4\u5f3a\u5927");
        messages.add(chatMessage);
        String requestId = String.format(requestIdTemplate, System.currentTimeMillis());
        ArrayList<ChatTool> chatToolList = new ArrayList<ChatTool>();
        ChatTool chatTool = new ChatTool();
        chatTool.setType(ChatToolType.FUNCTION.value());
        ChatFunctionParameters chatFunctionParameters = new ChatFunctionParameters();
        chatFunctionParameters.setType("object");
        HashMap<String, HashMap> properties = new HashMap<String, HashMap>();
        properties.put("departure", new HashMap<String, Object>(){
            {
                this.put("type", "string");
                this.put("description", "\u51fa\u53d1\u57ce\u5e02\u6216\u8f66\u7ad9");
            }
        });
        properties.put("destination", new HashMap<String, Object>(){
            {
                this.put("type", "string");
                this.put("description", "\u76ee\u7684\u5730\u57ce\u5e02\u6216\u8f66\u7ad9");
            }
        });
        properties.put("date", new HashMap<String, Object>(){
            {
                this.put("type", "string");
                this.put("description", "\u8981\u67e5\u8be2\u7684\u8f66\u6b21\u65e5\u671f");
            }
        });
        ArrayList<String> required = new ArrayList<String>();
        required.add("departure");
        required.add("destination");
        required.add("date");
        chatFunctionParameters.setProperties(properties);
        ChatFunction chatFunction = ChatFunction.builder().name("query_train_info").description("\u6839\u636e\u7528\u6237\u63d0\u4f9b\u7684\u4fe1\u606f\uff0c\u67e5\u8be2\u5bf9\u5e94\u7684\u8f66\u6b21").parameters(chatFunctionParameters).required(required).build();
        chatTool.setFunction(chatFunction);
        chatToolList.add(chatTool);
        ChatCompletionRequest chatCompletionRequest = ChatCompletionRequest.builder().model("GLM-4").stream(Boolean.TRUE).messages(messages).requestId(requestId).tools(chatToolList).toolChoice("auto").build();
        ModelApiResponse sseModelApiResp = client.invokeModelApi(chatCompletionRequest);
        if (sseModelApiResp.isSuccess()) {
            AtomicBoolean isFirst = new AtomicBoolean(true);
            ChatMessageAccumulator chatMessageAccumulator = (ChatMessageAccumulator)V4OkHttpClientTest.mapStreamToAccumulator(sseModelApiResp.getFlowable()).doOnNext(accumulator -> {
                if (isFirst.getAndSet(false)) {
                    System.out.print("Response: ");
                }
                if (accumulator.getDelta() != null && accumulator.getDelta().getTool_calls() != null) {
                    String jsonString = mapper.writeValueAsString(accumulator.getDelta().getTool_calls());
                    System.out.println("tool_calls: " + jsonString);
                }
                if (accumulator.getDelta() != null && accumulator.getDelta().getContent() != null) {
                    System.out.print(accumulator.getDelta().getContent());
                }
            }).doOnComplete(System.out::println).lastElement().blockingGet();
            Choice choice = new Choice(chatMessageAccumulator.getChoice().getFinishReason(), 0L, chatMessageAccumulator.getDelta());
            ArrayList<Choice> choices = new ArrayList<Choice>();
            choices.add(choice);
            ModelData data = new ModelData();
            data.setChoices(choices);
            data.setUsage(chatMessageAccumulator.getUsage());
            data.setId(chatMessageAccumulator.getId());
            data.setCreated(chatMessageAccumulator.getCreated());
            data.setRequestId(chatCompletionRequest.getRequestId());
            sseModelApiResp.setFlowable(null);
            sseModelApiResp.setData(data);
        }
        System.out.println("model output:" + JSON.toJSONString((Object)sseModelApiResp));
    }

    public static Flowable<ChatMessageAccumulator> mapStreamToAccumulator(Flowable<ModelData> flowable) {
        return flowable.map(chunk -> new ChatMessageAccumulator(chunk.getChoices().get(0).getDelta(), null, chunk.getChoices().get(0), chunk.getUsage(), chunk.getCreated(), chunk.getId()));
    }

    private static void testInvoke() {
        ArrayList<ChatMessage> messages = new ArrayList<ChatMessage>();
        ChatMessage chatMessage = new ChatMessage(ChatMessageRole.USER.value(), "ChatGLM\u548c\u4f60\u54ea\u4e2a\u66f4\u5f3a\u5927");
        messages.add(chatMessage);
        String requestId = String.format(requestIdTemplate, System.currentTimeMillis());
        ArrayList<ChatTool> chatToolList = new ArrayList<ChatTool>();
        ChatTool chatTool = new ChatTool();
        chatTool.setType(ChatToolType.FUNCTION.value());
        ChatFunctionParameters chatFunctionParameters = new ChatFunctionParameters();
        chatFunctionParameters.setType("object");
        HashMap<String, HashMap> properties = new HashMap<String, HashMap>();
        properties.put("location", new HashMap<String, Object>(){
            {
                this.put("type", "string");
                this.put("description", "\u57ce\u5e02\uff0c\u5982\uff1a\u5317\u4eac");
            }
        });
        properties.put("unit", new HashMap<String, Object>(){
            {
                this.put("type", "string");
                this.put("enum", new ArrayList<String>(){
                    {
                        this.add("celsius");
                        this.add("fahrenheit");
                    }
                });
            }
        });
        chatFunctionParameters.setProperties(properties);
        ChatFunction chatFunction = ChatFunction.builder().name("get_weather").description("Get the current weather of a location").parameters(chatFunctionParameters).build();
        chatTool.setFunction(chatFunction);
        chatToolList.add(chatTool);
        ChatCompletionRequest chatCompletionRequest = ChatCompletionRequest.builder().model("GLM-4").stream(Boolean.FALSE).invokeMethod("invoke").messages(messages).requestId(requestId).tools(chatToolList).toolChoice("auto").build();
        ModelApiResponse invokeModelApiResp = client.invokeModelApi(chatCompletionRequest);
        try {
            System.out.println("model output:" + mapper.writeValueAsString((Object)invokeModelApiResp));
        }
        catch (JsonProcessingException e) {
            e.printStackTrace();
        }
    }

    private static String testAsyncInvoke() {
        ArrayList<ChatMessage> messages = new ArrayList<ChatMessage>();
        ChatMessage chatMessage = new ChatMessage(ChatMessageRole.USER.value(), "ChatLM\u548c\u4f60\u54ea\u4e2a\u66f4\u5f3a\u5927");
        messages.add(chatMessage);
        String requestId = String.format(requestIdTemplate, System.currentTimeMillis());
        ArrayList<ChatTool> chatToolList = new ArrayList<ChatTool>();
        ChatTool chatTool = new ChatTool();
        chatTool.setType(ChatToolType.FUNCTION.value());
        ChatFunctionParameters chatFunctionParameters = new ChatFunctionParameters();
        chatFunctionParameters.setType("object");
        HashMap<String, HashMap> properties = new HashMap<String, HashMap>();
        properties.put("location", new HashMap<String, Object>(){
            {
                this.put("type", "string");
                this.put("description", "\u57ce\u5e02\uff0c\u5982\uff1a\u5317\u4eac");
            }
        });
        properties.put("unit", new HashMap<String, Object>(){
            {
                this.put("type", "string");
                this.put("enum", new ArrayList<String>(){
                    {
                        this.add("celsius");
                        this.add("fahrenheit");
                    }
                });
            }
        });
        chatFunctionParameters.setProperties(properties);
        ChatFunction chatFunction = ChatFunction.builder().name("get_weather").description("Get the current weather of a location").parameters(chatFunctionParameters).build();
        chatTool.setFunction(chatFunction);
        chatToolList.add(chatTool);
        ChatCompletionRequest chatCompletionRequest = ChatCompletionRequest.builder().model("GLM-4").stream(Boolean.FALSE).invokeMethod("async-invoke").messages(messages).requestId(requestId).tools(chatToolList).toolChoice("auto").build();
        ModelApiResponse invokeModelApiResp = client.invokeModelApi(chatCompletionRequest);
        System.out.println("model output:" + JSON.toJSONString((Object)invokeModelApiResp));
        return invokeModelApiResp.getData().getTaskId();
    }

    private static void testQueryResult(String taskId) {
        QueryModelResultRequest request = new QueryModelResultRequest();
        request.setTaskId(taskId);
        QueryModelResultResponse queryResultResp = client.queryModelResult(request);
        try {
            System.out.println("model output:" + mapper.writeValueAsString((Object)queryResultResp));
        }
        catch (JsonProcessingException e) {
            e.printStackTrace();
        }
    }
}

