/*
 * Decompiled with CFR 0.152.
 */
package cn.afterturn.easypoi.excel;

import cn.afterturn.easypoi.cache.HtmlCache;
import cn.afterturn.easypoi.excel.entity.ExcelToHtmlParams;
import cn.afterturn.easypoi.excel.entity.enmus.ExcelType;
import cn.afterturn.easypoi.excel.html.HtmlToExcelService;
import cn.afterturn.easypoi.exception.excel.ExcelExportException;
import cn.afterturn.easypoi.exception.excel.enums.ExcelExportEnum;
import java.io.IOException;
import java.io.InputStream;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.util.IOUtils;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class ExcelXorHtmlUtil {
    private ExcelXorHtmlUtil() {
    }

    public static String toTableHtml(Workbook wb) {
        return HtmlCache.getHtml(new ExcelToHtmlParams(wb, false, 0, null));
    }

    public static String toAllHtml(Workbook wb) {
        return HtmlCache.getHtml(new ExcelToHtmlParams(wb, true, 0, null));
    }

    public static String excelToHtml(ExcelToHtmlParams params) {
        return HtmlCache.getHtml(params);
    }

    public static Workbook htmlToExcel(String html, ExcelType type) {
        Object workbook = null;
        workbook = ExcelType.HSSF.equals((Object)type) ? new HSSFWorkbook() : new XSSFWorkbook();
        new HtmlToExcelService().createSheet(html, (Workbook)workbook);
        return workbook;
    }

    public static Workbook htmlToExcel(InputStream is, ExcelType type) {
        try {
            return ExcelXorHtmlUtil.htmlToExcel(new String(IOUtils.toByteArray((InputStream)is)), type);
        }
        catch (IOException e) {
            throw new ExcelExportException(ExcelExportEnum.HTML_ERROR, (Throwable)e);
        }
    }
}

