/*
 * Decompiled with CFR 0.152.
 */
package br.com.caelum.vraptor.view;

import br.com.caelum.vraptor.Result;
import br.com.caelum.vraptor.View;
import br.com.caelum.vraptor.proxy.MethodInvocation;
import br.com.caelum.vraptor.proxy.Proxifier;
import br.com.caelum.vraptor.proxy.SuperMethod;
import br.com.caelum.vraptor.serialization.NoRootSerialization;
import br.com.caelum.vraptor.serialization.Serializer;
import br.com.caelum.vraptor.serialization.SerializerBuilder;
import br.com.caelum.vraptor.validator.Message;
import br.com.caelum.vraptor.validator.ValidationException;
import br.com.caelum.vraptor.view.EmptyResult;
import br.com.caelum.vraptor.view.ResultException;
import br.com.caelum.vraptor.view.ValidationViewsFactory;
import java.lang.reflect.Method;
import java.util.List;
import net.vidageek.mirror.dsl.Mirror;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultValidationViewsFactory
implements ValidationViewsFactory {
    private final Result result;
    private final Proxifier proxifier;

    public DefaultValidationViewsFactory(Result result, Proxifier proxifier) {
        this.result = result;
        this.proxifier = proxifier;
    }

    @Override
    public <T extends View> T instanceFor(Class<T> view, List<Message> errors) {
        if (view.equals(EmptyResult.class)) {
            throw new ValidationException(errors);
        }
        return (T)((View)this.proxifier.proxify(view, this.throwValidationErrorOnFinalMethods(view, errors, this.result.use(view))));
    }

    private <T> MethodInvocation<T> throwValidationErrorOnFinalMethods(final Class<T> view, final List<Message> errors, final T viewInstance) {
        return new MethodInvocation<T>(){

            @Override
            public Object intercept(T proxy, Method method, Object[] args, SuperMethod superMethod) {
                Object instance = new Mirror().on(viewInstance).invoke().method(method).withArgs(args);
                Class<?> type = method.getReturnType();
                if (type == Void.TYPE) {
                    throw new ValidationException(errors);
                }
                if (view.isAssignableFrom(type)) {
                    return proxy;
                }
                if (args.length > 0 && args[0] instanceof Class) {
                    return DefaultValidationViewsFactory.this.proxifier.proxify((Class)args[0], DefaultValidationViewsFactory.this.throwValidationExceptionOnFirstInvocation(errors, instance));
                }
                if (Serializer.class.isAssignableFrom(type) || SerializerBuilder.class.isAssignableFrom(type) || NoRootSerialization.class.isAssignableFrom(type)) {
                    return DefaultValidationViewsFactory.this.proxifier.proxify(type, DefaultValidationViewsFactory.this.throwValidationErrorOnFinalMethods(type, errors, type.cast(instance)));
                }
                throw new ResultException("It's not possible to create a validation version of " + method + ". You must provide a Custom Validation version of your class, or inform this corner case to VRaptor developers");
            }
        };
    }

    private <T> MethodInvocation<T> throwValidationExceptionOnFirstInvocation(final List<Message> errors, final T instance) {
        return new MethodInvocation<T>(){

            @Override
            public Object intercept(Object proxy, Method method, Object[] args, SuperMethod superMethod) {
                new Mirror().on(instance).invoke().method(method).withArgs(args);
                throw new ValidationException(errors);
            }
        };
    }
}

