/*
 * Decompiled with CFR 0.152.
 */
package br.com.caelum.vraptor.view;

import br.com.caelum.vraptor.core.MethodInfo;
import br.com.caelum.vraptor.http.MutableRequest;
import br.com.caelum.vraptor.proxy.MethodInvocation;
import br.com.caelum.vraptor.proxy.Proxifier;
import br.com.caelum.vraptor.proxy.ProxyInvocationException;
import br.com.caelum.vraptor.proxy.SuperMethod;
import br.com.caelum.vraptor.resource.DefaultResourceMethod;
import br.com.caelum.vraptor.resource.ResourceMethod;
import br.com.caelum.vraptor.view.PageResult;
import br.com.caelum.vraptor.view.PathResolver;
import br.com.caelum.vraptor.view.ResultException;
import java.io.IOException;
import java.lang.reflect.Method;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultPageResult
implements PageResult {
    private static final Logger logger = LoggerFactory.getLogger(DefaultPageResult.class);
    private final MutableRequest request;
    private final HttpServletResponse response;
    private final ResourceMethod method;
    private final PathResolver resolver;
    private final Proxifier proxifier;

    public DefaultPageResult(MutableRequest req, HttpServletResponse res, MethodInfo requestInfo, PathResolver resolver, Proxifier proxifier) {
        this.request = req;
        this.response = res;
        this.proxifier = proxifier;
        this.method = requestInfo.getResourceMethod();
        this.resolver = resolver;
    }

    @Override
    public void defaultView() {
        try {
            String to = this.resolver.pathFor(this.method);
            logger.debug("forwarding to {}", (Object)to);
            this.request.getRequestDispatcher(to).forward((ServletRequest)this.request, (ServletResponse)this.response);
        }
        catch (ServletException e) {
            throw new ResultException(e);
        }
        catch (IOException e) {
            throw new ResultException(e);
        }
    }

    @Override
    public void include() {
        try {
            String to = this.resolver.pathFor(this.method);
            logger.debug("including {}", (Object)to);
            this.request.getRequestDispatcher(to).include((ServletRequest)this.request, (ServletResponse)this.response);
        }
        catch (ServletException e) {
            throw new ResultException(e);
        }
        catch (IOException e) {
            throw new ResultException(e);
        }
    }

    @Override
    public void redirectTo(String url) {
        logger.debug("redirection to {}", (Object)url);
        try {
            if (url.startsWith("/")) {
                this.response.sendRedirect(this.request.getContextPath() + url);
            } else {
                this.response.sendRedirect(url);
            }
        }
        catch (IOException e) {
            throw new ResultException(e);
        }
    }

    @Override
    public void forwardTo(String url) {
        logger.debug("forwarding to {}", (Object)url);
        try {
            this.request.getRequestDispatcher(url).forward((ServletRequest)this.request, (ServletResponse)this.response);
        }
        catch (ServletException e) {
            throw new ResultException(e);
        }
        catch (IOException e) {
            throw new ResultException(e);
        }
    }

    @Override
    public <T> T of(final Class<T> controllerType) {
        return this.proxifier.proxify(controllerType, new MethodInvocation<T>(){

            @Override
            public Object intercept(T proxy, Method method, Object[] args, SuperMethod superMethod) {
                try {
                    DefaultPageResult.this.request.getRequestDispatcher(DefaultPageResult.this.resolver.pathFor(DefaultResourceMethod.instanceFor(controllerType, method))).forward((ServletRequest)DefaultPageResult.this.request, (ServletResponse)DefaultPageResult.this.response);
                    return null;
                }
                catch (Exception e) {
                    throw new ProxyInvocationException(e);
                }
            }
        });
    }

    @Override
    public void redirect(String url) {
        this.redirectTo(url);
    }

    @Override
    public void forward(String url) {
        this.forwardTo(url);
    }

    @Override
    public void forward() {
        this.defaultView();
    }
}

