/*
 * Decompiled with CFR 0.152.
 */
package br.com.caelum.vraptor.view;

import br.com.caelum.vraptor.view.HttpResult;
import br.com.caelum.vraptor.view.ResultException;
import br.com.caelum.vraptor.view.Status;
import com.google.common.io.ByteStreams;
import com.google.common.io.CharStreams;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import javax.servlet.http.HttpServletResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultHttpResult
implements HttpResult {
    private final HttpServletResponse response;
    private final Status status;

    public DefaultHttpResult(HttpServletResponse response, Status status) {
        this.response = response;
        this.status = status;
    }

    @Override
    public HttpResult addDateHeader(String name, long date) {
        this.response.addDateHeader(name, date);
        return this;
    }

    @Override
    public HttpResult addHeader(String name, String value) {
        this.response.addHeader(name, value);
        return this;
    }

    @Override
    public HttpResult addIntHeader(String name, int value) {
        this.response.addIntHeader(name, value);
        return this;
    }

    @Override
    public void sendError(int statusCode) {
        try {
            this.response.sendError(statusCode);
        }
        catch (IOException e) {
            throw new ResultException("Error while setting status code", e);
        }
    }

    @Override
    public void sendError(int statusCode, String message) {
        try {
            this.response.sendError(statusCode, message);
        }
        catch (IOException e) {
            throw new ResultException("Error while setting status code", e);
        }
    }

    @Override
    public void setStatusCode(int statusCode) {
        this.response.setStatus(statusCode);
    }

    @Override
    public void movedPermanentlyTo(String uri) {
        this.status.movedPermanentlyTo(uri);
    }

    @Override
    public <T> T movedPermanentlyTo(Class<T> controller) {
        return this.status.movedPermanentlyTo(controller);
    }

    @Override
    public HttpResult body(String body) {
        try {
            this.response.getWriter().print(body);
        }
        catch (IOException e) {
            throw new ResultException("Couldn't write to response body", e);
        }
        return this;
    }

    @Override
    public HttpResult body(InputStream body) {
        try {
            ByteStreams.copy((InputStream)body, (OutputStream)this.response.getOutputStream());
        }
        catch (IOException e) {
            throw new ResultException("Couldn't write to response body", e);
        }
        return this;
    }

    @Override
    public HttpResult body(Reader body) {
        try {
            CharStreams.copy((Readable)body, (Appendable)this.response.getWriter());
        }
        catch (IOException e) {
            throw new ResultException("Couldn't write to response body", e);
        }
        return this;
    }
}

