/*
 * Decompiled with CFR 0.152.
 */
package br.com.caelum.vraptor.util.test;

import br.com.caelum.vraptor.View;
import br.com.caelum.vraptor.http.FormatResolver;
import br.com.caelum.vraptor.interceptor.DefaultTypeNameExtractor;
import br.com.caelum.vraptor.ioc.Component;
import br.com.caelum.vraptor.proxy.CglibProxifier;
import br.com.caelum.vraptor.proxy.ObjenesisInstanceCreator;
import br.com.caelum.vraptor.proxy.Proxifier;
import br.com.caelum.vraptor.serialization.DefaultRepresentationResult;
import br.com.caelum.vraptor.serialization.JSONSerialization;
import br.com.caelum.vraptor.serialization.NullProxyInitializer;
import br.com.caelum.vraptor.serialization.ProxyInitializer;
import br.com.caelum.vraptor.serialization.RepresentationResult;
import br.com.caelum.vraptor.serialization.Serialization;
import br.com.caelum.vraptor.serialization.XMLSerialization;
import br.com.caelum.vraptor.serialization.xstream.XStreamBuilder;
import br.com.caelum.vraptor.serialization.xstream.XStreamBuilderImpl;
import br.com.caelum.vraptor.serialization.xstream.XStreamJSONSerialization;
import br.com.caelum.vraptor.serialization.xstream.XStreamXMLSerialization;
import br.com.caelum.vraptor.util.test.MockHttpServletResponse;
import br.com.caelum.vraptor.util.test.MockResult;
import br.com.caelum.vraptor.view.EmptyResult;
import com.thoughtworks.xstream.converters.Converter;
import java.util.Arrays;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component
public class MockSerializationResult
extends MockResult {
    private Serialization serialization;
    private MockHttpServletResponse response;
    private DefaultTypeNameExtractor extractor;
    private ProxyInitializer initializer;
    private XStreamBuilder builder;

    public MockSerializationResult(Proxifier proxifier, ProxyInitializer initializer) {
        this(proxifier, initializer, XStreamBuilderImpl.cleanInstance(new Converter[0]));
    }

    public MockSerializationResult(Proxifier proxifier, ProxyInitializer initializer, XStreamBuilder builder) {
        super(proxifier);
        this.initializer = initializer;
        this.response = new MockHttpServletResponse();
        this.extractor = new DefaultTypeNameExtractor();
        this.builder = builder;
    }

    public MockSerializationResult() {
        this(new CglibProxifier(new ObjenesisInstanceCreator()), new NullProxyInitializer());
    }

    public MockSerializationResult(XStreamBuilder builder) {
        this(new CglibProxifier(new ObjenesisInstanceCreator()), new NullProxyInitializer(), builder);
    }

    @Override
    public <T extends View> T use(Class<T> view) {
        this.typeToUse = view;
        if (view.equals(EmptyResult.class)) {
            return null;
        }
        return this.instanceView(view);
    }

    private <T extends View> T instanceView(Class<T> view) {
        if (view.isAssignableFrom(JSONSerialization.class)) {
            this.serialization = new XStreamJSONSerialization(this.response, this.extractor, this.initializer, this.builder);
            return (T)((View)view.cast(this.serialization));
        }
        if (view.isAssignableFrom(XMLSerialization.class)) {
            this.serialization = new XStreamXMLSerialization(this.response, this.extractor, this.initializer, this.builder);
            return (T)((View)view.cast(this.serialization));
        }
        if (view.isAssignableFrom(RepresentationResult.class)) {
            this.serialization = new XStreamXMLSerialization(this.response, this.extractor, this.initializer, this.builder);
            return (T)((View)view.cast(new DefaultRepresentationResult(new FormatResolver(){

                public String getAcceptFormat() {
                    return "xml";
                }
            }, this, Arrays.asList(this.serialization), null)));
        }
        return (T)((View)this.proxifier.proxify(view, this.returnOnFinalMethods(view)));
    }

    public String serializedResult() throws Exception {
        if ("application/xml".equals(this.response.getContentType())) {
            return this.response.getContentAsString();
        }
        if ("application/json".equals(this.response.getContentType())) {
            return this.response.getContentAsString();
        }
        return null;
    }
}

