/*
 * Decompiled with CFR 0.152.
 */
package br.com.caelum.vraptor.util.jpa.extra;

import br.com.caelum.vraptor.Converter;
import br.com.caelum.vraptor.InterceptionException;
import br.com.caelum.vraptor.Intercepts;
import br.com.caelum.vraptor.Lazy;
import br.com.caelum.vraptor.Result;
import br.com.caelum.vraptor.core.Converters;
import br.com.caelum.vraptor.core.InterceptorStack;
import br.com.caelum.vraptor.core.Localization;
import br.com.caelum.vraptor.http.ParameterNameProvider;
import br.com.caelum.vraptor.interceptor.Interceptor;
import br.com.caelum.vraptor.interceptor.ParametersInstantiatorInterceptor;
import br.com.caelum.vraptor.resource.ResourceMethod;
import br.com.caelum.vraptor.util.jpa.extra.Load;
import br.com.caelum.vraptor.view.FlashScope;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.Arrays;
import javax.persistence.EntityManager;
import javax.servlet.http.HttpServletRequest;
import net.vidageek.mirror.dsl.Mirror;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Intercepts(before={ParametersInstantiatorInterceptor.class})
@Lazy
public class ParameterLoaderInterceptor
implements Interceptor {
    private final EntityManager em;
    private final HttpServletRequest request;
    private final ParameterNameProvider provider;
    private final Result result;
    private final Converters converters;
    private final Localization localization;
    private final FlashScope flash;

    public ParameterLoaderInterceptor(EntityManager em, HttpServletRequest request, ParameterNameProvider provider, Result result, Converters converters, Localization localization, FlashScope flash) {
        this.em = em;
        this.request = request;
        this.provider = provider;
        this.result = result;
        this.converters = converters;
        this.localization = localization;
        this.flash = flash;
    }

    @Override
    public boolean accepts(ResourceMethod method) {
        return Iterables.any(Arrays.asList(method.getMethod().getParameterAnnotations()), this.hasLoadAnnotation());
    }

    @Override
    public void intercept(InterceptorStack stack, ResourceMethod method, Object resourceInstance) throws InterceptionException {
        Annotation[][] annotations = method.getMethod().getParameterAnnotations();
        String[] names = this.provider.parameterNamesFor(method.getMethod());
        Class<?>[] types = method.getMethod().getParameterTypes();
        Object[] args = this.flash.consumeParameters(method);
        for (int i = 0; i < names.length; ++i) {
            Iterable loads = Iterables.filter(Arrays.asList(annotations[i]), Load.class);
            if (Iterables.isEmpty((Iterable)loads)) continue;
            Object loaded = this.load(names[i], types[i]);
            if (loaded == null) {
                this.result.notFound();
                return;
            }
            if (args != null) {
                args[i] = loaded;
                continue;
            }
            this.request.setAttribute(names[i], loaded);
        }
        this.flash.includeParameters(method, args);
        stack.next(method, resourceInstance);
    }

    private Object load(String name, Class type) {
        String parameter = this.request.getParameter(name + ".id");
        if (parameter == null) {
            return null;
        }
        Field field = new Mirror().on(type).reflect().field("id");
        Preconditions.checkArgument((field != null ? 1 : 0) != 0, (Object)("Entity " + type.getSimpleName() + " must have an id property for @Load."));
        Class<?> idType = field.getType();
        Converter<?> converter = this.converters.to(idType);
        Preconditions.checkArgument((converter != null ? 1 : 0) != 0, (Object)("Entity " + type.getSimpleName() + " id type " + idType + " must have a converter"));
        Serializable id = (Serializable)converter.convert(parameter, type, this.localization.getBundle());
        return this.em.find(type, (Object)id);
    }

    private Predicate<Annotation[]> hasLoadAnnotation() {
        return new Predicate<Annotation[]>(){

            public boolean apply(Annotation[] param) {
                return Iterables.any(Arrays.asList(param), (Predicate)Predicates.instanceOf(Load.class));
            }
        };
    }
}

