/*
 * Decompiled with CFR 0.152.
 */
package br.com.caelum.vraptor.serialization.xstream;

import br.com.caelum.vraptor.interceptor.TypeNameExtractor;
import br.com.caelum.vraptor.ioc.Component;
import br.com.caelum.vraptor.serialization.ProxyInitializer;
import br.com.caelum.vraptor.serialization.Serializer;
import br.com.caelum.vraptor.serialization.SerializerBuilder;
import br.com.caelum.vraptor.serialization.XMLSerialization;
import br.com.caelum.vraptor.serialization.xstream.XStreamBuilder;
import br.com.caelum.vraptor.serialization.xstream.XStreamSerializer;
import br.com.caelum.vraptor.view.ResultException;
import com.thoughtworks.xstream.XStream;
import java.io.IOException;
import javax.servlet.http.HttpServletResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component
public class XStreamXMLSerialization
implements XMLSerialization {
    private final HttpServletResponse response;
    private final TypeNameExtractor extractor;
    private final ProxyInitializer initializer;
    private final XStreamBuilder builder;

    public XStreamXMLSerialization(HttpServletResponse response, TypeNameExtractor extractor, ProxyInitializer initializer, XStreamBuilder builder) {
        this.response = response;
        this.extractor = extractor;
        this.initializer = initializer;
        this.builder = builder;
    }

    @Override
    public boolean accepts(String format) {
        return "xml".equals(format);
    }

    @Override
    public <T> Serializer from(T object) {
        this.response.setContentType("application/xml");
        return this.getSerializer().from(object);
    }

    protected SerializerBuilder getSerializer() {
        try {
            return new XStreamSerializer(this.getXStream(), this.response.getWriter(), this.extractor, this.initializer);
        }
        catch (IOException e) {
            throw new ResultException("Unable to serialize data", e);
        }
    }

    @Override
    public <T> Serializer from(T object, String alias) {
        this.response.setContentType("application/xml");
        return this.getSerializer().from(object, alias);
    }

    @Deprecated
    protected XStream getXStream() {
        return this.builder.xmlInstance();
    }
}

