/*
 * Decompiled with CFR 0.152.
 */
package br.com.caelum.vraptor.serialization;

import br.com.caelum.vraptor.Result;
import br.com.caelum.vraptor.http.FormatResolver;
import br.com.caelum.vraptor.restfulie.RestHeadersHandler;
import br.com.caelum.vraptor.restfulie.hypermedia.HypermediaResource;
import br.com.caelum.vraptor.serialization.IgnoringSerializer;
import br.com.caelum.vraptor.serialization.PackageComparator;
import br.com.caelum.vraptor.serialization.RepresentationResult;
import br.com.caelum.vraptor.serialization.Serialization;
import br.com.caelum.vraptor.serialization.Serializer;
import br.com.caelum.vraptor.view.Results;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultRepresentationResult
implements RepresentationResult {
    private final FormatResolver formatResolver;
    private List<Serialization> serializations;
    private final Result result;
    private final RestHeadersHandler headersHandler;

    public DefaultRepresentationResult(FormatResolver formatResolver, Result result, List<Serialization> serializations, RestHeadersHandler headersHandler) {
        this.formatResolver = formatResolver;
        this.result = result;
        this.serializations = serializations;
        this.headersHandler = headersHandler;
    }

    @Override
    public <T> Serializer from(T object) {
        return this.from(object, null);
    }

    protected void sortSerializations() {
        Collections.sort(this.serializations, new PackageComparator());
    }

    @Override
    public <T> Serializer from(T object, String alias) {
        if (object == null) {
            this.result.use(Results.status()).notFound();
            return new IgnoringSerializer();
        }
        if (HypermediaResource.class.isAssignableFrom(object.getClass())) {
            this.headersHandler.handle((HypermediaResource)HypermediaResource.class.cast(object));
        }
        this.sortSerializations();
        String format = this.formatResolver.getAcceptFormat();
        for (Serialization serialization : this.serializations) {
            if (!serialization.accepts(format)) continue;
            if (alias == null) {
                return serialization.from(object);
            }
            return serialization.from(object, alias);
        }
        this.result.use(Results.status()).notAcceptable();
        return new IgnoringSerializer();
    }
}

