/*
 * Decompiled with CFR 0.152.
 */
package br.com.caelum.vraptor.scan;

import br.com.caelum.vraptor.scan.ClasspathResolver;
import br.com.caelum.vraptor.scan.ScannerException;
import br.com.caelum.vraptor.scan.StandaloneClasspathResolver;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.servlet.ServletContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebBasedClasspathResolver
implements ClasspathResolver {
    private final ServletContext servletContext;

    public WebBasedClasspathResolver(ServletContext servletContext) {
        this.servletContext = servletContext;
    }

    @Override
    public ClassLoader getClassLoader() {
        if (this.servletContext.getMajorVersion() == 3) {
            return this.servletContext.getClassLoader();
        }
        return Thread.currentThread().getContextClassLoader();
    }

    @Override
    public URL findWebInfClassesLocation() {
        try {
            String webInfClassesDir = this.servletContext.getRealPath("/WEB-INF/classes");
            if (webInfClassesDir != null) {
                return new URL("file:" + webInfClassesDir + "/");
            }
            return new StandaloneClasspathResolver().findWebInfClassesLocation();
        }
        catch (Exception e) {
            throw new ScannerException("Could not determine WEB-INF/classes location", e);
        }
    }

    @Override
    public List<String> findBasePackages() {
        ArrayList<String> packages = new ArrayList<String>();
        String packagesParam = this.servletContext.getInitParameter("br.com.caelum.vraptor.packages");
        if (packagesParam != null) {
            Collections.addAll(packages, packagesParam.trim().split("\\s*,\\s*"));
        }
        new StandaloneClasspathResolver().getPackagesFromPluginsJARs(packages);
        return packages;
    }
}

