/*
 * Decompiled with CFR 0.152.
 */
package br.com.caelum.vraptor.proxy;

import br.com.caelum.vraptor.ioc.ApplicationScoped;
import br.com.caelum.vraptor.proxy.InstanceCreator;
import br.com.caelum.vraptor.proxy.ProxyCreationException;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ApplicationScoped
public class ReflectionInstanceCreator
implements InstanceCreator {
    private final Logger logger = LoggerFactory.getLogger(ReflectionInstanceCreator.class);

    @Override
    public <T> T instanceFor(Class<T> clazz) {
        Constructor<?>[] constructors = clazz.getDeclaredConstructors();
        Constructor<?> defaultConstructor = this.findDefaultConstructor(constructors);
        if (defaultConstructor != null) {
            this.logger.debug("Default constructor found in {} ", clazz);
            return this.useDefaultConstructor(clazz);
        }
        this.logger.info(String.format("No default constructor found for %s. Trying to create the proxy with other constructors (there are %d).", clazz, constructors.length));
        return this.tryAllConstructors(clazz, constructors);
    }

    private <T> T useDefaultConstructor(Class<T> clazz) {
        try {
            return clazz.newInstance();
        }
        catch (Exception e) {
            throw new ProxyCreationException(e);
        }
    }

    private <T> T tryAllConstructors(Class<T> type, Constructor<?>[] constructors) {
        ArrayList<Throwable> problems = new ArrayList<Throwable>();
        for (Constructor<?> constructor : constructors) {
            Object[] parameterTypes = constructor.getParameterTypes();
            Object[] parameterValues = this.proxyParameters((Class<?>[])parameterTypes);
            if (this.logger.isDebugEnabled()) {
                Object[] params = new Object[]{Arrays.toString(parameterTypes), Arrays.toString(parameterValues)};
                this.logger.debug("trying constructor with following parameters types: {} values are going to be: {}", params);
            }
            try {
                Object newInstance = constructor.newInstance(parameterValues);
                return type.cast(newInstance);
            }
            catch (Throwable e) {
                this.logger.debug("Problem while calling constructor with parameters {}. Trying next.", constructor.getParameterTypes(), (Object)e);
                problems.add(e);
            }
        }
        String message = String.format("Tried to instantiate type: %s %d times, but none of the attempts worked. The exceptions are: %s", type, constructors.length, problems);
        throw new ProxyCreationException(message);
    }

    private Object[] proxyParameters(Class<?>[] parameterTypes) {
        return new Object[parameterTypes.length];
    }

    private Constructor<?> findDefaultConstructor(Constructor<?>[] constructors) {
        for (Constructor<?> constructor : constructors) {
            if (constructor.getParameterTypes().length != 0) continue;
            return constructor;
        }
        return null;
    }
}

