/*
 * Decompiled with CFR 0.152.
 */
package br.com.caelum.vraptor.proxy;

import br.com.caelum.vraptor.ioc.ApplicationScoped;
import br.com.caelum.vraptor.proxy.InstanceCreator;
import br.com.caelum.vraptor.proxy.MethodInvocation;
import br.com.caelum.vraptor.proxy.Proxifier;
import br.com.caelum.vraptor.proxy.ProxyInvocationException;
import br.com.caelum.vraptor.proxy.SuperMethod;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import javassist.util.proxy.MethodFilter;
import javassist.util.proxy.MethodHandler;
import javassist.util.proxy.ProxyFactory;
import javassist.util.proxy.ProxyObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ApplicationScoped
public class JavassistProxifier
implements Proxifier {
    private static final Logger logger = LoggerFactory.getLogger(JavassistProxifier.class);
    private static final List<Method> OBJECT_METHODS = Arrays.asList(Object.class.getDeclaredMethods());
    private static final MethodFilter IGNORE_BRIDGE_AND_OBJECT_METHODS = new MethodFilter(){

        public boolean isHandled(Method method) {
            return !method.isBridge() && !OBJECT_METHODS.contains(method);
        }
    };
    private final InstanceCreator instanceCreator;

    public JavassistProxifier(InstanceCreator instanceCreator) {
        this.instanceCreator = instanceCreator;
    }

    @Override
    public <T> T proxify(Class<T> type, MethodInvocation<? super T> handler) {
        ProxyFactory factory = new ProxyFactory();
        factory.setFilter(IGNORE_BRIDGE_AND_OBJECT_METHODS);
        if (type.isInterface()) {
            factory.setInterfaces(new Class[]{type});
        } else {
            factory.setSuperclass(type);
        }
        Class proxyClass = factory.createClass();
        Object proxyInstance = this.instanceCreator.instanceFor(proxyClass);
        this.setHandler(proxyInstance, handler);
        logger.debug("a proxy for {} is created as {}", type, (Object)proxyClass);
        return type.cast(proxyInstance);
    }

    @Override
    public boolean isProxy(Object o) {
        return o != null && ProxyObject.class.isAssignableFrom(o.getClass());
    }

    private <T> void setHandler(Object proxyInstance, final MethodInvocation<? super T> handler) {
        ProxyObject proxyObject = (ProxyObject)proxyInstance;
        proxyObject.setHandler(new MethodHandler(){

            public Object invoke(Object self, Method thisMethod, final Method proceed, Object[] args) throws Throwable {
                return handler.intercept(self, thisMethod, args, new SuperMethod(){

                    public Object invoke(Object proxy, Object[] args) {
                        try {
                            return proceed.invoke(proxy, args);
                        }
                        catch (Throwable throwable) {
                            throw new ProxyInvocationException(throwable);
                        }
                    }
                });
            }
        });
    }
}

