/*
 * Decompiled with CFR 0.152.
 */
package br.com.caelum.vraptor.ioc.spring;

import br.com.caelum.vraptor.ioc.ApplicationScoped;
import br.com.caelum.vraptor.ioc.PrototypeScoped;
import br.com.caelum.vraptor.ioc.RequestScoped;
import br.com.caelum.vraptor.ioc.SessionScoped;
import java.util.LinkedHashMap;
import java.util.Map;
import org.springframework.beans.factory.annotation.AnnotatedBeanDefinition;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.context.annotation.ScopeMetadata;
import org.springframework.context.annotation.ScopeMetadataResolver;
import org.springframework.core.type.AnnotationMetadata;

class VRaptorScopeResolver
implements ScopeMetadataResolver {
    private final Map<String, String> scopes = new LinkedHashMap<String, String>();

    public VRaptorScopeResolver() {
        this.scopes.put(RequestScoped.class.getName(), "request");
        this.scopes.put(SessionScoped.class.getName(), "session");
        this.scopes.put(ApplicationScoped.class.getName(), "singleton");
        this.scopes.put(PrototypeScoped.class.getName(), "prototype");
    }

    public ScopeMetadata resolveScopeMetadata(BeanDefinition definition) {
        AnnotationMetadata metadata = ((AnnotatedBeanDefinition)definition).getMetadata();
        for (Map.Entry<String, String> scope : this.scopes.entrySet()) {
            if (!metadata.hasAnnotation(scope.getKey())) continue;
            ScopeMetadata scopeMetadata = new ScopeMetadata();
            scopeMetadata.setScopeName(scope.getValue());
            return scopeMetadata;
        }
        return this.requestScopeAsDefault();
    }

    private ScopeMetadata requestScopeAsDefault() {
        ScopeMetadata singleton = new ScopeMetadata();
        singleton.setScopeName("request");
        return singleton;
    }
}

