/*
 * Decompiled with CFR 0.152.
 */
package br.com.caelum.vraptor.ioc.spring;

import br.com.caelum.vraptor.ioc.AbstractComponentRegistry;
import br.com.caelum.vraptor.ioc.Container;
import br.com.caelum.vraptor.ioc.spring.SpringRegistry;
import com.google.common.collect.Sets;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.web.context.ConfigurableWebApplicationContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpringBasedContainer
extends AbstractComponentRegistry
implements Container {
    private static final Logger logger = LoggerFactory.getLogger(SpringBasedContainer.class);
    final Set<Class<?>> toRegister = Sets.newHashSet();
    private final ConfigurableWebApplicationContext parentContext;

    public SpringBasedContainer(ConfigurableWebApplicationContext parentContext) {
        this.parentContext = parentContext;
    }

    @Override
    public void register(Class<?> requiredType, Class<?> componentType) {
        if (this.parentContext.isActive() && "VRaptor".equals(this.parentContext.getId())) {
            logger.info("registering class {} to {} after container initialization. Please avoid this", requiredType, componentType);
            new SpringRegistry(this.parentContext.getBeanFactory(), this).register(componentType);
        } else {
            this.toRegister.add(componentType);
        }
    }

    @Override
    public <T> T instanceFor(Class<T> type) {
        try {
            return (T)this.parentContext.getBean(type);
        }
        catch (NoSuchBeanDefinitionException e) {
            Map beans = this.parentContext.getBeansOfType(type);
            for (Map.Entry def : beans.entrySet()) {
                BeanDefinition definition = this.parentContext.getBeanFactory().getBeanDefinition((String)def.getKey());
                if (!this.isPrimary(definition) && !this.hasGreaterRoleThanInfrastructure(definition)) continue;
                return (T)def.getValue();
            }
            throw e;
        }
    }

    @Override
    public <T> boolean canProvide(Class<T> type) {
        return BeanFactoryUtils.beanNamesForTypeIncludingAncestors((ListableBeanFactory)this.parentContext, type).length > 0;
    }

    public void start(ServletContext context) {
        this.parentContext.setServletContext(context);
        this.parentContext.addBeanFactoryPostProcessor((BeanFactoryPostProcessor)new BeanRegistrationProcessor(this));
        this.parentContext.refresh();
        this.parentContext.start();
    }

    public void stop() {
        this.parentContext.stop();
        if (this.parentContext instanceof DisposableBean) {
            try {
                ((DisposableBean)this.parentContext).destroy();
            }
            catch (Exception e) {
                logger.error("Error when destroying application context", (Throwable)e);
            }
        }
    }

    private boolean isPrimary(BeanDefinition definition) {
        return definition instanceof AbstractBeanDefinition && ((AbstractBeanDefinition)definition).isPrimary();
    }

    private boolean hasGreaterRoleThanInfrastructure(BeanDefinition definition) {
        return definition.getRole() < 2;
    }

    private static final class BeanRegistrationProcessor
    implements BeanFactoryPostProcessor {
        private final SpringBasedContainer container;

        public BeanRegistrationProcessor(SpringBasedContainer container) {
            this.container = container;
        }

        public void postProcessBeanFactory(ConfigurableListableBeanFactory factory) throws BeansException {
            SpringRegistry registry = new SpringRegistry(factory, this.container);
            registry.configure();
            registry.registerCustomComponents(this.container.toRegister);
        }
    }
}

