/*
 * Decompiled with CFR 0.152.
 */
package br.com.caelum.vraptor.ioc.pico;

import br.com.caelum.vraptor.ComponentRegistry;
import br.com.caelum.vraptor.Converter;
import br.com.caelum.vraptor.config.BasicConfiguration;
import br.com.caelum.vraptor.core.BaseComponents;
import br.com.caelum.vraptor.core.Execution;
import br.com.caelum.vraptor.core.RequestInfo;
import br.com.caelum.vraptor.ioc.Container;
import br.com.caelum.vraptor.ioc.ContainerProvider;
import br.com.caelum.vraptor.ioc.StereotypeHandler;
import br.com.caelum.vraptor.ioc.pico.DefaultComponentFactoryRegistry;
import br.com.caelum.vraptor.ioc.pico.PicoBasedContainer;
import br.com.caelum.vraptor.ioc.pico.PicoComponentRegistry;
import br.com.caelum.vraptor.scan.WebAppBootstrap;
import br.com.caelum.vraptor.scan.WebAppBootstrapFactory;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletContext;
import org.picocontainer.ComponentFactory;
import org.picocontainer.ComponentMonitor;
import org.picocontainer.DefaultPicoContainer;
import org.picocontainer.LifecycleStrategy;
import org.picocontainer.MutablePicoContainer;
import org.picocontainer.Parameter;
import org.picocontainer.behaviors.Caching;
import org.picocontainer.lifecycle.JavaEE5LifecycleStrategy;
import org.picocontainer.monitors.NullComponentMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PicoProvider
implements ContainerProvider {
    private final MutablePicoContainer picoContainer;
    private MutablePicoContainer childContainer;
    private final ThreadLocal<Container> containersByThread = new ThreadLocal();
    private static final Logger logger = LoggerFactory.getLogger(PicoProvider.class);

    public PicoProvider() {
        this.picoContainer = new DefaultPicoContainer((ComponentFactory)new Caching(), (LifecycleStrategy)new JavaEE5LifecycleStrategy((ComponentMonitor)new NullComponentMonitor()), null);
        DefaultComponentFactoryRegistry componentFactoryRegistry = new DefaultComponentFactoryRegistry();
        PicoComponentRegistry componentRegistry = new PicoComponentRegistry(this.picoContainer, componentFactoryRegistry);
        this.picoContainer.addComponent((Object)componentRegistry);
        this.picoContainer.addComponent((Object)componentFactoryRegistry);
        this.picoContainer.addComponent(Container.class, (Object)new Container(){

            @Override
            public <T> T instanceFor(Class<T> type) {
                Container container = (Container)PicoProvider.this.containersByThread.get();
                if (container == null) {
                    return (T)PicoProvider.this.picoContainer.getComponent(type);
                }
                return container.instanceFor(type);
            }

            @Override
            public <T> boolean canProvide(Class<T> type) {
                return this.instanceFor(type) != null;
            }
        }, new Parameter[0]);
    }

    @Override
    public final void start(ServletContext context) {
        PicoComponentRegistry componentRegistry = this.getComponentRegistry();
        this.registerBundledComponents(componentRegistry);
        this.picoContainer.addComponent((Object)context);
        BasicConfiguration config = new BasicConfiguration(context);
        WebAppBootstrap webAppBootstrap = new WebAppBootstrapFactory().create(config);
        webAppBootstrap.configure(componentRegistry);
        this.registerCustomComponents(componentRegistry);
        this.getComponentRegistry().init();
        this.picoContainer.start();
        this.registerCacheComponents();
        Collection<Class<?>> components = this.getComponentRegistry().getAllRegisteredApplicationScopedComponents();
        List handlers = this.picoContainer.getComponents(StereotypeHandler.class);
        for (Class<?> type : components) {
            for (StereotypeHandler handler : handlers) {
                if (!type.isAnnotationPresent(handler.stereotype())) continue;
                handler.handle(type);
            }
        }
    }

    private void registerCacheComponents() {
        PicoComponentRegistry registry = this.getComponentRegistry();
        this.childContainer = registry.makeChildContainer();
        Map<Class<?>, Class<?>> cachedComponents = BaseComponents.getCachedComponents();
        for (Map.Entry<Class<?>, Class<?>> entry : cachedComponents.entrySet()) {
            registry.register(entry.getKey(), entry.getValue());
        }
        this.childContainer.start();
    }

    protected void registerBundledComponents(ComponentRegistry registry) {
        logger.debug("Registering base pico container related implementation components");
        for (Class<? extends StereotypeHandler> entry : BaseComponents.getStereotypeHandlers()) {
            registry.register(entry, entry);
        }
        this.registerAll(registry, BaseComponents.getApplicationScoped());
        this.registerAll(registry, BaseComponents.getRequestScoped());
        this.registerAll(registry, BaseComponents.getPrototypeScoped());
        for (Class<? extends Converter<?>> clazz : BaseComponents.getBundledConverters()) {
            registry.register(clazz, clazz);
        }
    }

    private void registerAll(ComponentRegistry registry, Map<Class<?>, Class<?>> scope) {
        for (Map.Entry<Class<?>, Class<?>> entry : scope.entrySet()) {
            registry.register(entry.getKey(), entry.getValue());
            registry.register(entry.getValue(), entry.getValue());
        }
    }

    protected void registerCustomComponents(ComponentRegistry registry) {
    }

    @Override
    public void stop() {
        this.picoContainer.stop();
        this.picoContainer.dispose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T provideForRequest(RequestInfo request, Execution<T> execution) {
        PicoBasedContainer container = null;
        try {
            container = this.getComponentRegistry().provideRequestContainer(request);
            container.getContainer().start();
            this.containersByThread.set(container);
            T t = execution.insideRequest(container);
            return t;
        }
        finally {
            if (container != null) {
                MutablePicoContainer picoContainer = container.getContainer();
                picoContainer.stop();
                picoContainer.dispose();
            }
            this.containersByThread.set(null);
        }
    }

    protected PicoComponentRegistry getComponentRegistry() {
        return (PicoComponentRegistry)this.picoContainer.getComponent(PicoComponentRegistry.class);
    }
}

