/*
 * Decompiled with CFR 0.152.
 */
package br.com.caelum.vraptor.ioc.guice;

import br.com.caelum.vraptor.ComponentRegistry;
import br.com.caelum.vraptor.config.BasicConfiguration;
import br.com.caelum.vraptor.core.Execution;
import br.com.caelum.vraptor.core.RequestInfo;
import br.com.caelum.vraptor.ioc.Container;
import br.com.caelum.vraptor.ioc.ContainerProvider;
import br.com.caelum.vraptor.ioc.StereotypeHandler;
import br.com.caelum.vraptor.ioc.guice.ApplicationCustomScope;
import br.com.caelum.vraptor.ioc.guice.GuiceComponentRegistry;
import br.com.caelum.vraptor.ioc.guice.RequestCustomScope;
import br.com.caelum.vraptor.ioc.guice.SessionCustomScope;
import br.com.caelum.vraptor.ioc.guice.VRaptorAbstractModule;
import br.com.caelum.vraptor.ioc.spring.VRaptorRequestHolder;
import br.com.caelum.vraptor.scan.WebAppBootstrap;
import br.com.caelum.vraptor.scan.WebAppBootstrapFactory;
import com.google.inject.Binder;
import com.google.inject.ConfigurationException;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.Stage;
import com.google.inject.TypeLiteral;
import com.google.inject.util.Modules;
import java.util.Set;
import javax.servlet.ServletContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GuiceProvider
implements ContainerProvider {
    private boolean stopSession = false;
    static final RequestCustomScope REQUEST = new RequestCustomScope();
    static final SessionCustomScope SESSION = new SessionCustomScope();
    static final ApplicationCustomScope APPLICATION = new ApplicationCustomScope();
    private Injector injector;
    private GuiceContainer container;
    protected ServletContext context;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T provideForRequest(RequestInfo request, Execution<T> execution) {
        VRaptorRequestHolder.setRequestForCurrentThread(request);
        REQUEST.start();
        try {
            T t = execution.insideRequest(this.container);
            return t;
        }
        finally {
            REQUEST.stop();
            VRaptorRequestHolder.resetRequestForCurrentThread();
        }
    }

    @Override
    public void start(ServletContext context) {
        this.context = context;
        APPLICATION.start();
        this.container = new GuiceContainer();
        this.injector = Guice.createInjector((Stage)Stage.PRODUCTION, (Module[])new Module[]{Modules.override((Module[])new Module[]{new VRaptorAbstractModule(context, this.container)}).with(new Module[]{this.customModule()})});
        this.executeStereotypeHandlers();
        this.injector.injectMembers((Object)REQUEST);
        this.injector.injectMembers((Object)SESSION);
    }

    private void executeStereotypeHandlers() {
        Set handlers = (Set)this.injector.getInstance(Key.get((TypeLiteral)new TypeLiteral<Set<StereotypeHandler>>(){}));
        for (Key key : this.injector.getAllBindings().keySet()) {
            for (StereotypeHandler handler : handlers) {
                Class type = key.getTypeLiteral().getRawType();
                if (!type.isAnnotationPresent(handler.stereotype())) continue;
                handler.handle(type);
            }
        }
    }

    protected Module customModule() {
        return new Module(){

            public void configure(Binder binder) {
                GuiceComponentRegistry registry = new GuiceComponentRegistry(binder);
                BasicConfiguration config = new BasicConfiguration(GuiceProvider.this.context);
                WebAppBootstrap webAppBootstrap = new WebAppBootstrapFactory().create(config);
                webAppBootstrap.configure(registry);
                GuiceProvider.this.registerCustomComponents(registry);
            }
        };
    }

    protected void registerCustomComponents(ComponentRegistry registry) {
    }

    protected void stopSession(Boolean value) {
        this.stopSession = value;
    }

    @Override
    public void stop() {
        if (this.stopSession) {
            SESSION.stopAll();
        }
        APPLICATION.stop();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class GuiceContainer
    implements Container {
        private GuiceContainer() {
        }

        @Override
        public <T> T instanceFor(Class<T> type) {
            return (T)GuiceProvider.this.injector.getInstance(type);
        }

        @Override
        public <T> boolean canProvide(Class<T> type) {
            try {
                return GuiceProvider.this.injector.getProvider(type) != null;
            }
            catch (ConfigurationException e) {
                return false;
            }
        }
    }
}

