/*
 * Decompiled with CFR 0.152.
 */
package br.com.caelum.vraptor.interceptor.multipart;

import br.com.caelum.vraptor.InterceptionException;
import br.com.caelum.vraptor.Intercepts;
import br.com.caelum.vraptor.Validator;
import br.com.caelum.vraptor.core.InterceptorStack;
import br.com.caelum.vraptor.http.MutableRequest;
import br.com.caelum.vraptor.interceptor.ParametersInstantiatorInterceptor;
import br.com.caelum.vraptor.interceptor.multipart.DefaultUploadedFile;
import br.com.caelum.vraptor.interceptor.multipart.MultipartInterceptor;
import br.com.caelum.vraptor.ioc.RequestScoped;
import br.com.caelum.vraptor.resource.ResourceMethod;
import br.com.caelum.vraptor.validator.Validations;
import com.google.common.base.Strings;
import com.google.common.collect.LinkedListMultimap;
import com.google.common.io.ByteStreams;
import com.google.common.io.Closeables;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.Collection;
import java.util.regex.Pattern;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.Part;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Intercepts(before={ParametersInstantiatorInterceptor.class})
@RequestScoped
public class Servlet3MultipartInterceptor
implements MultipartInterceptor {
    private static final Logger logger = LoggerFactory.getLogger(Servlet3MultipartInterceptor.class);
    private static final Pattern EXTRACT_FILENAME = Pattern.compile("(.*)filename=\"(.*)\"");
    public static final String ACCEPT_MULTIPART = "multipart/form-data";
    public static final String CONTENT_DISPOSITION_KEY = "content-disposition";
    private final HttpServletRequest request;
    private final MutableRequest parameters;
    private final Validator validator;

    public Servlet3MultipartInterceptor(HttpServletRequest request, MutableRequest parameters, Validator validator) {
        this.request = request;
        this.parameters = parameters;
        this.validator = validator;
    }

    public boolean accepts(ResourceMethod method) {
        if (!this.request.getMethod().toUpperCase().equals("POST")) {
            return false;
        }
        String contentType = this.request.getContentType();
        return contentType != null && contentType.startsWith(ACCEPT_MULTIPART);
    }

    public void intercept(InterceptorStack stack, ResourceMethod method, Object resourceInstance) throws InterceptionException {
        logger.info("Request contains multipart data. Try to parse with Servlet3 Part");
        LinkedListMultimap params = LinkedListMultimap.create();
        try {
            for (Part part : this.request.getParts()) {
                String name = part.getName();
                if (this.isField(part)) {
                    logger.debug("{} is a field", (Object)name);
                    params.put((Object)name, (Object)this.getStringValue(part));
                    continue;
                }
                logger.debug("{} is a file", (Object)name);
                String fileName = this.getFileName(part);
                DefaultUploadedFile upload = new DefaultUploadedFile(part.getInputStream(), fileName, part.getContentType());
                this.parameters.setParameter(name, name);
                this.request.setAttribute(name, (Object)upload);
            }
        }
        catch (IllegalStateException e) {
            this.reportSizeLimitExceeded(e);
        }
        catch (IOException e) {
            throw new InterceptionException(e);
        }
        catch (ServletException e) {
            throw new InterceptionException(e);
        }
        for (String paramName : params.keySet()) {
            Collection paramValues = params.get((Object)paramName);
            this.parameters.setParameter(paramName, paramValues.toArray(new String[paramValues.size()]));
        }
        stack.next(method, resourceInstance);
    }

    protected void reportSizeLimitExceeded(IllegalStateException e) {
        this.validator.checking(new Validations(){
            {
                this.that(false, "upload", "servlet3.upload.filesize.exceeded", new Object[0]);
            }
        });
        logger.warn("The file size limit was exceeded.", (Throwable)e);
    }

    private boolean isField(Part part) {
        return Strings.isNullOrEmpty((String)part.getContentType());
    }

    private String getFileName(Part part) {
        String name = part.getHeader(CONTENT_DISPOSITION_KEY);
        return EXTRACT_FILENAME.matcher(name).replaceAll("$2");
    }

    private String getStringValue(Part part) throws IOException {
        String encoding = this.request.getCharacterEncoding();
        InputStream in = part.getInputStream();
        byte[] out = ByteStreams.toByteArray((InputStream)in);
        Closeables.closeQuietly((Closeable)in);
        if (!Strings.isNullOrEmpty((String)encoding)) {
            try {
                return new String(out, encoding);
            }
            catch (UnsupportedEncodingException e) {
                logger.warn("Request have an invalid encoding. Ignoring it");
            }
        }
        return new String(out);
    }
}

