/*
 * Decompiled with CFR 0.152.
 */
package br.com.caelum.vraptor.interceptor.multipart;

import br.com.caelum.vraptor.interceptor.multipart.UploadedFile;
import java.io.InputStream;
import java.util.regex.Pattern;

public class DefaultUploadedFile
implements UploadedFile {
    static final Pattern REGEX_REMOVE_SLASHES = Pattern.compile(".*(?:\\\\|\\/)(.+)$");
    private final String contentType;
    private final String fileName;
    private final String completeFileName;
    private final InputStream content;

    public DefaultUploadedFile(InputStream content, String completeFileName, String contentType) {
        this.content = content;
        this.fileName = REGEX_REMOVE_SLASHES.matcher(completeFileName).replaceAll("$1");
        this.completeFileName = completeFileName;
        this.contentType = contentType;
    }

    public String toString() {
        return "[uploadedFile uploadedCompleteName=" + this.completeFileName + " uploadedName=" + this.fileName + " contentType=" + this.contentType + "]";
    }

    public String getContentType() {
        return this.contentType;
    }

    public InputStream getFile() {
        return this.content;
    }

    public String getFileName() {
        return this.fileName;
    }

    public String getCompleteFileName() {
        return this.completeFileName;
    }
}

