/*
 * Decompiled with CFR 0.152.
 */
package br.com.caelum.vraptor.interceptor;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Graph<E> {
    private final E DUMMY = null;
    private Multimap<E, E> graph = LinkedHashMultimap.create();
    private List<E> orderedList;
    private final Lock lock = new ReentrantLock();

    public void addEdge(E from, E to) {
        Preconditions.checkState((this.orderedList == null ? 1 : 0) != 0, (Object)"You shouldn't add more interceptors after ordering. Please notify vraptor developers.");
        this.graph.put(from, to);
    }

    public void addEdges(E from, E ... tos) {
        for (E to : tos) {
            this.addEdge(from, to);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<E> topologicalOrder() {
        if (this.orderedList == null) {
            this.lock.lock();
            try {
                if (this.orderedList == null) {
                    this.orderedList = this.orderTopologically();
                }
            }
            finally {
                this.lock.unlock();
            }
        }
        return this.orderedList;
    }

    private List<E> orderTopologically() {
        ArrayList list = Lists.newArrayList();
        this.addDummies();
        while (!this.graph.keySet().isEmpty()) {
            Set<E> roots = this.findRoots();
            if (roots.isEmpty()) {
                throw new IllegalStateException("There is a cycle on the interceptor sequence: \n" + this.cycle());
            }
            list.addAll(roots);
            this.removeRoots(roots);
        }
        return list;
    }

    private void addDummies() {
        Sets.SetView nodes = Sets.union((Set)this.graph.keySet(), (Set)Sets.newHashSet((Iterable)this.graph.values()));
        for (Object node : nodes) {
            this.graph.put(node, this.DUMMY);
        }
    }

    private void removeRoots(Set<E> roots) {
        for (E root : roots) {
            this.graph.removeAll(root);
        }
    }

    private Set<E> findRoots() {
        return Sets.difference((Set)this.graph.keySet(), (Set)Sets.newHashSet((Iterable)this.graph.values())).immutableCopy();
    }

    private String cycle() {
        this.removeLeaves();
        return this.findCycle().toString();
    }

    private List<E> findCycle() {
        Object node = Iterables.get((Iterable)this.graph.keySet(), (int)0);
        ArrayList cycle = Lists.newArrayList();
        do {
            cycle.add(node);
        } while (!cycle.contains(node = Iterables.get((Iterable)this.graph.get(node), (int)0)));
        return cycle.subList(cycle.indexOf(node), cycle.size());
    }

    private void removeLeaves() {
        Set<E> leaves = this.findLeaves();
        if (leaves.isEmpty()) {
            return;
        }
        for (Object key : Sets.newHashSet((Iterable)this.graph.keySet())) {
            for (E value : leaves) {
                this.graph.remove(key, value);
            }
        }
        this.removeLeaves();
    }

    private Set<E> findLeaves() {
        return Sets.difference((Set)Sets.newHashSet((Iterable)this.graph.values()), (Set)this.graph.keySet());
    }
}

