/*
 * Decompiled with CFR 0.152.
 */
package br.com.caelum.vraptor.interceptor;

import br.com.caelum.vraptor.InterceptionException;
import br.com.caelum.vraptor.Intercepts;
import br.com.caelum.vraptor.Result;
import br.com.caelum.vraptor.core.ExceptionMapper;
import br.com.caelum.vraptor.core.ExceptionRecorder;
import br.com.caelum.vraptor.core.InterceptorStack;
import br.com.caelum.vraptor.interceptor.Interceptor;
import br.com.caelum.vraptor.resource.ResourceMethod;
import com.google.common.base.Throwables;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Intercepts
public class ExceptionHandlerInterceptor
implements Interceptor {
    private static final Logger logger = LoggerFactory.getLogger(ExceptionHandlerInterceptor.class);
    private final ExceptionMapper exceptions;
    private final Result result;
    private final HttpServletRequest request;

    public ExceptionHandlerInterceptor(ExceptionMapper exceptions, Result result, HttpServletRequest request) {
        this.exceptions = exceptions;
        this.result = result;
        this.request = request;
    }

    public boolean accepts(ResourceMethod method) {
        return true;
    }

    public void intercept(InterceptorStack stack, ResourceMethod method, Object resourceInstance) throws InterceptionException {
        block2: {
            try {
                stack.next(method, resourceInstance);
            }
            catch (InterceptionException e) {
                if (e.getCause() instanceof Exception && this.replay((Exception)e.getCause())) break block2;
                throw e;
            }
        }
    }

    protected void reportException(Exception e) {
        Throwable rootCause = Throwables.getRootCause((Throwable)e);
        this.result.include("javax.servlet.error.status_code", 500);
        this.result.include("javax.servlet.error.exception", rootCause);
        this.result.include("javax.servlet.error.exception_type", rootCause.getClass());
        this.result.include("javax.servlet.error.message", rootCause.getMessage());
        this.result.include("javax.servlet.error.request_uri", this.request.getRequestURI());
    }

    protected boolean replay(Exception e) {
        ExceptionRecorder<Result> exresult = this.exceptions.findByException(e);
        if (exresult == null) {
            return false;
        }
        this.reportException(e);
        logger.debug("handling exception {}", e.getClass());
        exresult.replay(this.result);
        return true;
    }
}

