/*
 * Decompiled with CFR 0.152.
 */
package br.com.caelum.vraptor.http.route;

import br.com.caelum.vraptor.Delete;
import br.com.caelum.vraptor.Get;
import br.com.caelum.vraptor.Path;
import br.com.caelum.vraptor.Post;
import br.com.caelum.vraptor.Put;
import br.com.caelum.vraptor.http.route.Route;
import br.com.caelum.vraptor.http.route.RouteBuilder;
import br.com.caelum.vraptor.http.route.Router;
import br.com.caelum.vraptor.http.route.RoutesParser;
import br.com.caelum.vraptor.ioc.ApplicationScoped;
import br.com.caelum.vraptor.resource.HttpMethod;
import br.com.caelum.vraptor.resource.ResourceClass;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import javassist.Modifier;
import net.vidageek.mirror.dsl.Mirror;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ApplicationScoped
public class PathAnnotationRoutesParser
implements RoutesParser {
    private final Router router;

    public PathAnnotationRoutesParser(Router router) {
        this.router = router;
    }

    @Override
    public List<Route> rulesFor(ResourceClass resource) {
        Class<?> baseType = resource.getType();
        return this.registerRulesFor(baseType);
    }

    protected List<Route> registerRulesFor(Class<?> baseType) {
        EnumSet<HttpMethod> typeMethods = this.getHttpMethods(baseType);
        ArrayList<Route> routes = new ArrayList<Route>();
        for (Method javaMethod : baseType.getMethods()) {
            String[] uris;
            if (!this.isEligible(javaMethod)) continue;
            for (String uri : uris = this.getURIsFor(javaMethod, baseType)) {
                RouteBuilder rule = this.router.builderFor(uri);
                EnumSet<HttpMethod> methods = this.getHttpMethods(javaMethod);
                rule.with(methods.isEmpty() ? typeMethods : methods);
                if (javaMethod.isAnnotationPresent(Path.class)) {
                    rule.withPriority(javaMethod.getAnnotation(Path.class).priority());
                }
                if (this.getUris(javaMethod).length > 0) {
                    rule.withPriority(0x3FFFFFFF);
                }
                rule.is(baseType, javaMethod);
                routes.add(rule.build());
            }
        }
        return routes;
    }

    private EnumSet<HttpMethod> getHttpMethods(AnnotatedElement annotated) {
        EnumSet<HttpMethod> methods = EnumSet.noneOf(HttpMethod.class);
        for (HttpMethod method : HttpMethod.values()) {
            if (!annotated.isAnnotationPresent(method.getAnnotation())) continue;
            methods.add(method);
        }
        return methods;
    }

    protected boolean isEligible(Method javaMethod) {
        return Modifier.isPublic((int)javaMethod.getModifiers()) && !Modifier.isStatic((int)javaMethod.getModifiers()) && !javaMethod.isBridge() && !javaMethod.getDeclaringClass().equals(Object.class);
    }

    protected String[] getURIsFor(Method javaMethod, Class<?> type) {
        if (javaMethod.isAnnotationPresent(Path.class)) {
            String[] uris = javaMethod.getAnnotation(Path.class).value();
            Preconditions.checkArgument((uris.length > 0 ? 1 : 0) != 0, (Object)("You must specify at least one path on @Path at " + javaMethod));
            Preconditions.checkArgument((this.getUris(javaMethod).length == 0 ? 1 : 0) != 0, (Object)("You should specify paths either in @Path(\"/path\") or @Get(\"/path\") (or @Post, @Put, @Delete), not both at " + javaMethod));
            this.fixURIs(type, uris);
            return uris;
        }
        String[] uris = this.getUris(javaMethod);
        if (uris.length > 0) {
            this.fixURIs(type, uris);
            return uris;
        }
        return new String[]{this.defaultUriFor(this.extractControllerNameFrom(type), javaMethod.getName())};
    }

    private String[] getUris(Method javaMethod) {
        Annotation method = (Annotation)Iterables.find(Arrays.asList(javaMethod.getAnnotations()), this.instanceOfMethodAnnotation(), null);
        if (method == null) {
            return new String[0];
        }
        return (String[])new Mirror().on((Object)method).invoke().method("value").withoutArgs();
    }

    protected void fixURIs(Class<?> type, String[] uris) {
        String prefix = this.extractPrefix(type);
        for (int i = 0; i < uris.length; ++i) {
            uris[i] = "".equals(prefix) ? this.fixLeadingSlash(uris[i]) : ("".equals(uris[i]) ? prefix : this.removeTrailingSlash(prefix) + this.fixLeadingSlash(uris[i]));
        }
    }

    protected String removeTrailingSlash(String prefix) {
        return prefix.replaceFirst("/$", "");
    }

    protected String extractPrefix(Class<?> type) {
        if (type.isAnnotationPresent(Path.class)) {
            String[] uris = type.getAnnotation(Path.class).value();
            if (uris.length != 1) {
                throw new IllegalArgumentException("You must specify exactly one path on @Path at " + type);
            }
            return this.fixLeadingSlash(uris[0]);
        }
        return "";
    }

    private String fixLeadingSlash(String uri) {
        if (!uri.startsWith("/")) {
            return "/" + uri;
        }
        return uri;
    }

    protected String extractControllerNameFrom(Class<?> type) {
        String prefix = this.extractPrefix(type);
        if ("".equals(prefix)) {
            String baseName = this.lowerFirstCharacter(type.getSimpleName());
            if (baseName.endsWith("Controller")) {
                return "/" + baseName.substring(0, baseName.lastIndexOf("Controller"));
            }
            return "/" + baseName;
        }
        return prefix;
    }

    protected String defaultUriFor(String controllerName, String methodName) {
        return controllerName + "/" + methodName;
    }

    protected String lowerFirstCharacter(String baseName) {
        return baseName.toLowerCase().substring(0, 1) + baseName.substring(1, baseName.length());
    }

    private Predicate<Annotation> instanceOfMethodAnnotation() {
        return Predicates.or((Predicate[])new Predicate[]{Predicates.instanceOf(Get.class), Predicates.instanceOf(Post.class), Predicates.instanceOf(Put.class), Predicates.instanceOf(Delete.class)});
    }
}

