/*
 * Decompiled with CFR 0.152.
 */
package br.com.caelum.vraptor.http.ognl;

import br.com.caelum.vraptor.Converter;
import br.com.caelum.vraptor.core.Converters;
import br.com.caelum.vraptor.ioc.RequestScoped;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Map;
import java.util.ResourceBundle;
import ognl.TypeConverter;

@RequestScoped
public class VRaptorConvertersAdapter
implements TypeConverter {
    private final Converters converters;
    private final ResourceBundle bundle;

    public VRaptorConvertersAdapter(Converters converters, ResourceBundle bundle) {
        this.converters = converters;
        this.bundle = bundle;
    }

    public Object convertValue(Map context, Object target, Member member, String propertyName, Object value, Class toType) {
        Type genericType = this.genericTypeToConvert(target, member);
        Class type = VRaptorConvertersAdapter.rawTypeOf(genericType);
        if (type.isArray() && !value.getClass().isArray()) {
            Class<?> arrayType = type.getComponentType();
            Object array = Array.newInstance(arrayType, 1);
            Array.set(array, 0, this.convert(value, arrayType));
            return array;
        }
        return this.convert(value, type);
    }

    Object convert(Object value, Class type) {
        Converter converter = this.converters.to(type);
        if (converter == null) {
            throw new IllegalArgumentException("Cannot instantiate a converter for type " + type.getName());
        }
        return converter.convert((String)value, type, this.bundle);
    }

    private Type genericTypeToConvert(Object target, Member member) {
        if (member instanceof Field) {
            return this.extractFieldType(member);
        }
        if (member instanceof Method) {
            return this.extractSetterMethodType(target, member);
        }
        if (member == null && target.getClass().isArray()) {
            return this.extractArrayType(target);
        }
        throw new IllegalArgumentException("Vraptor can only navigate through getter/setter methods, not " + member + " from " + target.getClass().getName());
    }

    private static Class rawTypeOf(Type genericType) {
        if (genericType instanceof ParameterizedType) {
            return (Class)((ParameterizedType)genericType).getRawType();
        }
        return (Class)genericType;
    }

    private Type extractArrayType(Object target) {
        return target.getClass().getComponentType();
    }

    private Type extractFieldType(Member member) {
        return ((Field)member).getGenericType();
    }

    private Type extractSetterMethodType(Object target, Member member) {
        Method method = (Method)member;
        Type[] parameterTypes = method.getGenericParameterTypes();
        if (parameterTypes.length != 1) {
            throw new IllegalArgumentException("Vraptor can only navigate through setters with one parameter, not " + member + " from " + target.getClass().getName());
        }
        return parameterTypes[0];
    }
}

