/*
 * Decompiled with CFR 0.152.
 */
package br.com.caelum.vraptor.http.ognl;

import br.com.caelum.vraptor.converter.ConversionError;
import br.com.caelum.vraptor.http.InvalidParameterException;
import br.com.caelum.vraptor.http.ParameterNameProvider;
import br.com.caelum.vraptor.http.ParametersProvider;
import br.com.caelum.vraptor.http.ognl.OgnlFacade;
import br.com.caelum.vraptor.ioc.Container;
import br.com.caelum.vraptor.ioc.RequestScoped;
import br.com.caelum.vraptor.resource.ResourceMethod;
import br.com.caelum.vraptor.validator.Message;
import br.com.caelum.vraptor.validator.ValidationMessage;
import com.google.common.base.Defaults;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Maps;
import java.lang.reflect.Array;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@RequestScoped
public class OgnlParametersProvider
implements ParametersProvider {
    private final ParameterNameProvider provider;
    private static final Logger logger = LoggerFactory.getLogger(OgnlParametersProvider.class);
    private final HttpServletRequest request;
    private final Container container;
    private final OgnlFacade ognl;

    public OgnlParametersProvider(ParameterNameProvider provider, HttpServletRequest request, Container container, OgnlFacade ognl) {
        this.provider = provider;
        this.request = request;
        this.container = container;
        this.ognl = ognl;
    }

    @Override
    public Object[] getParametersFor(ResourceMethod method, List<Message> errors, ResourceBundle bundle) {
        String[] names = this.provider.parameterNamesFor(method.getMethod());
        Type[] types = method.getMethod().getGenericParameterTypes();
        Class<?>[] classes = method.getMethod().getParameterTypes();
        Object[] result = new Object[types.length];
        for (int i = 0; i < types.length; ++i) {
            Map<String, String[]> requestNames = this.parametersThatStartWith(names[i]);
            result[i] = this.createParameter(new Parameter(types[i], classes[i], names[i], method), requestNames, bundle, errors);
        }
        return result;
    }

    private Object createParameter(Parameter param, Map<String, String[]> requestNames, ResourceBundle bundle, List<Message> errors) {
        if (this.request.getAttribute(param.name) != null) {
            return this.request.getAttribute(param.name);
        }
        if (param.clazz.isInterface() && this.container.canProvide(param.clazz)) {
            return this.container.instanceFor(param.clazz);
        }
        if (requestNames.isEmpty()) {
            return Defaults.defaultValue((Class)param.actualType());
        }
        Object root = this.createRoot(param, requestNames, bundle, errors);
        if (root == null) {
            return null;
        }
        this.ognl.startContext(param.name, param.type, root, bundle);
        for (Map.Entry<String, String[]> parameter : requestNames.entrySet()) {
            String key = parameter.getKey().replaceFirst("^" + param.name + "\\.?", "");
            String[] values = parameter.getValue();
            this.setProperty(param.name, key, values, errors);
        }
        return this.ognl.get(param.name);
    }

    private Object createRoot(Parameter param, Map<String, String[]> requestNames, ResourceBundle bundle, List<Message> errors) {
        if (requestNames.containsKey(param.name)) {
            String[] values = requestNames.get(param.name);
            try {
                return this.createSimpleParameter(param, values, bundle);
            }
            catch (ConversionError ex) {
                errors.add(new ValidationMessage(ex.getMessage(), param.name));
                return null;
            }
        }
        try {
            return this.ognl.nullHandler().instantiate(param.actualType());
        }
        catch (Exception ex) {
            throw new InvalidParameterException("unable to instantiate type " + param.type, ex);
        }
    }

    private void setProperty(String name, String key, String[] values, List<Message> errors) {
        try {
            logger.debug("Applying {} with {}", (Object)key, (Object)values);
            this.ognl.setValue(name, key, values);
        }
        catch (ConversionError ex) {
            errors.add(new ValidationMessage(ex.getMessage(), key));
        }
    }

    private Object createSimpleParameter(Parameter param, String[] values, ResourceBundle bundle) {
        if (param.actualType().isArray()) {
            return this.createArray(param.actualType(), values, bundle);
        }
        if (List.class.isAssignableFrom(param.actualType())) {
            return this.createList(param.type, bundle, values);
        }
        return this.convert(param.actualType(), values[0], bundle);
    }

    private Object convert(Class clazz, String value, ResourceBundle bundle) {
        return this.ognl.createAdapter(bundle).convert(value, clazz);
    }

    private List createList(Type type, ResourceBundle bundle, String[] values) {
        ArrayList<Object> list = new ArrayList<Object>();
        Class actual = this.getActualType(type);
        for (String value : values) {
            list.add(this.convert(actual, value, bundle));
        }
        return list;
    }

    private Object createArray(Class clazz, String[] values, ResourceBundle bundle) {
        Class<?> arrayType = clazz.getComponentType();
        Object array = Array.newInstance(arrayType, values.length);
        for (int i = 0; i < values.length; ++i) {
            Array.set(array, i, this.convert(arrayType, values[i], bundle));
        }
        return array;
    }

    private Class getActualType(Type type) {
        return (Class)((ParameterizedType)type).getActualTypeArguments()[0];
    }

    private Map<String, String[]> parametersThatStartWith(String name) {
        Map requestNames = Maps.filterKeys((Map)this.request.getParameterMap(), (Predicate)Predicates.containsPattern((String)("^" + name)));
        return requestNames;
    }

    private static class Parameter {
        public Type type;
        public Class clazz;
        public String name;
        public ResourceMethod method;

        public Parameter(Type type, Class clazz, String name, ResourceMethod method) {
            this.type = type;
            this.clazz = clazz;
            this.name = name;
            this.method = method;
        }

        public Class actualType() {
            if (this.type instanceof TypeVariable) {
                ParameterizedType superclass = (ParameterizedType)this.method.getResource().getType().getGenericSuperclass();
                return (Class)superclass.getActualTypeArguments()[0];
            }
            return this.clazz;
        }
    }
}

