/*
 * Decompiled with CFR 0.152.
 */
package br.com.caelum.vraptor.http.ognl;

import br.com.caelum.vraptor.Converter;
import br.com.caelum.vraptor.core.Converters;
import br.com.caelum.vraptor.http.ognl.ReflectionBasedNullHandler;
import br.com.caelum.vraptor.proxy.Proxifier;
import br.com.caelum.vraptor.util.StringUtils;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import ognl.Evaluation;
import ognl.ListPropertyAccessor;
import ognl.OgnlContext;
import ognl.OgnlException;

public class ListAccessor
extends ListPropertyAccessor {
    private final Converters converters;

    public ListAccessor(Converters converters) {
        this.converters = converters;
    }

    public Object getProperty(Map context, Object target, Object value) throws OgnlException {
        try {
            return super.getProperty(context, target, value);
        }
        catch (IndexOutOfBoundsException ex) {
            return null;
        }
    }

    public void setProperty(Map context, Object target, Object key, Object value) throws OgnlException {
        List list = (List)target;
        int index = (Integer)key;
        for (int i = list.size(); i <= index; ++i) {
            list.add(null);
        }
        if (value instanceof String) {
            OgnlContext ctx = (OgnlContext)context;
            Type genericType = this.extractGenericType(ctx, target);
            Class type = this.getActualType(genericType);
            Converter converter = this.converters.to(type);
            ResourceBundle bundle = (ResourceBundle)context.get(ResourceBundle.class);
            Object result = converter.convert((String)value, type, bundle);
            super.setProperty(context, target, key, result);
            return;
        }
        super.setProperty(context, target, key, value);
    }

    private Class getActualType(Type genericType) {
        Class type = genericType instanceof ParameterizedType ? (Class)((ParameterizedType)genericType).getActualTypeArguments()[0] : (Class)genericType;
        return type;
    }

    private Type extractGenericType(OgnlContext ctx, Object target) {
        Type genericType;
        if (ctx.getRoot() != target) {
            Evaluation eval = ctx.getCurrentEvaluation();
            Evaluation previous = eval.getPrevious();
            String fieldName = previous.getNode().toString();
            Object origin = previous.getSource();
            Proxifier proxifier = (Proxifier)ctx.get((Object)"proxifier");
            Method getter = new ReflectionBasedNullHandler(proxifier).findGetter(origin, StringUtils.capitalize(fieldName));
            genericType = getter.getGenericReturnType();
        } else {
            genericType = (Type)ctx.get((Object)"rootType");
        }
        return genericType;
    }
}

