/*
 * Decompiled with CFR 0.152.
 */
package br.com.caelum.vraptor.http.ognl;

import br.com.caelum.vraptor.VRaptorException;
import br.com.caelum.vraptor.ioc.RequestScoped;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@RequestScoped
public class EmptyElementsRemoval {
    private final Set<Collection<?>> collections = new HashSet();
    private final Map<SetValue, Object> arrays = new HashMap<SetValue, Object>();

    public void removeExtraElements() {
        for (Collection<?> collection : this.collections) {
            Iterator<?> iterator = collection.iterator();
            while (iterator.hasNext()) {
                Object object = iterator.next();
                if (object != null) continue;
                iterator.remove();
            }
        }
        this.collections.clear();
        for (SetValue setter : this.arrays.keySet()) {
            Object array = this.arrays.get(setter);
            Object newArray = this.removeNullsFromArray(array);
            try {
                setter.set(newArray);
            }
            catch (InvocationTargetException e) {
                throw new VRaptorException(e.getCause());
            }
            catch (Exception e) {
                throw new IllegalArgumentException(e);
            }
        }
        this.arrays.clear();
    }

    public Object removeNullsFromArray(Object array) {
        int length;
        int total = length = Array.getLength(array);
        for (int i = 0; i < length; ++i) {
            if (Array.get(array, i) != null) continue;
            --total;
        }
        Object newArray = Array.newInstance(array.getClass().getComponentType(), total);
        int actual = 0;
        for (int i = 0; i < length; ++i) {
            Object value = Array.get(array, i);
            if (value == null) continue;
            Array.set(newArray, actual++, value);
        }
        return newArray;
    }

    public void add(Collection<?> collection) {
        this.collections.add(collection);
    }

    public void add(Object array, Method setter, Object instance) {
        this.arrays.put(new SetValue(instance, setter), array);
    }

    class SetValue {
        private final Method method;
        private final Object instance;

        public SetValue(Object instance, Method setter) {
            this.instance = instance;
            this.method = setter;
        }

        void set(Object newValue) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
            this.method.invoke(this.instance, newValue);
            EmptyElementsRemoval.this.arrays.put(this, newValue);
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof SetValue)) {
                return false;
            }
            SetValue other = (SetValue)obj;
            return this.method.equals(other.method) && this.instance.equals(other.instance);
        }

        public int hashCode() {
            return this.method.hashCode();
        }
    }
}

