/*
 * Decompiled with CFR 0.152.
 */
package br.com.caelum.vraptor.http.iogi;

import br.com.caelum.iogi.parameters.Parameter;
import br.com.caelum.iogi.parameters.Parameters;
import br.com.caelum.iogi.reflection.Target;
import br.com.caelum.vraptor.http.ParameterNameProvider;
import br.com.caelum.vraptor.http.ParametersProvider;
import br.com.caelum.vraptor.http.iogi.InstantiatorWithErrors;
import br.com.caelum.vraptor.ioc.Component;
import br.com.caelum.vraptor.ioc.RequestScoped;
import br.com.caelum.vraptor.resource.ResourceMethod;
import br.com.caelum.vraptor.validator.Message;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.ResourceBundle;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component
@RequestScoped
public class IogiParametersProvider
implements ParametersProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(IogiParametersProvider.class);
    private final ParameterNameProvider nameProvider;
    private final HttpServletRequest servletRequest;
    private final InstantiatorWithErrors instantiator;

    public IogiParametersProvider(ParameterNameProvider provider, HttpServletRequest parameters, InstantiatorWithErrors instantiator) {
        this.nameProvider = provider;
        this.servletRequest = parameters;
        this.instantiator = instantiator;
        LOGGER.debug("IogiParametersProvider is up");
    }

    @Override
    public Object[] getParametersFor(ResourceMethod method, List<Message> errors, ResourceBundle bundle) {
        Parameters parameters = this.parseParameters(this.servletRequest);
        List<Target<Object>> targets = this.createTargets(method);
        List<Object> arguments = this.instantiateParameters(parameters, targets, errors);
        return arguments.toArray();
    }

    private List<Object> instantiateParameters(Parameters parameters, List<Target<Object>> targets, List<Message> errors) {
        LOGGER.debug("getParametersFor() called with parameters {} and targets {}.", (Object)parameters, targets);
        ArrayList<Object> arguments = new ArrayList<Object>();
        for (Target<Object> target : targets) {
            Object newObject = this.instantiateOrAddError(parameters, errors, target);
            arguments.add(newObject);
        }
        return arguments;
    }

    private Object instantiateOrAddError(Parameters parameters, List<Message> errors, Target<Object> target) {
        return this.instantiator.instantiate(target, parameters, errors);
    }

    private List<Target<Object>> createTargets(ResourceMethod method) {
        Method javaMethod = method.getMethod();
        ArrayList<Target<Object>> targets = new ArrayList<Target<Object>>();
        Type[] parameterTypes = javaMethod.getGenericParameterTypes();
        String[] parameterNames = this.nameProvider.parameterNamesFor(javaMethod);
        for (int i = 0; i < this.methodArity(javaMethod); ++i) {
            if (parameterTypes[i] instanceof TypeVariable) {
                ParameterizedType superclass = (ParameterizedType)method.getResource().getType().getGenericSuperclass();
                parameterTypes[i] = superclass.getActualTypeArguments()[0];
            }
            Target newTarget = new Target(parameterTypes[i], parameterNames[i]);
            targets.add((Target<Object>)newTarget);
        }
        return targets;
    }

    private int methodArity(Method method) {
        return method.getGenericParameterTypes().length;
    }

    private Parameters parseParameters(HttpServletRequest request) {
        ArrayList<Parameter> parameterList = new ArrayList<Parameter>();
        Enumeration enumeration = request.getParameterNames();
        while (enumeration.hasMoreElements()) {
            String[] parameterValues;
            String parameterName = (String)enumeration.nextElement();
            for (String value : parameterValues = request.getParameterValues(parameterName)) {
                Parameter newParameter = new Parameter(parameterName, value);
                parameterList.add(newParameter);
            }
        }
        return new Parameters(parameterList);
    }
}

