/*
 * Decompiled with CFR 0.152.
 */
package br.com.caelum.vraptor.deserialization;

import br.com.caelum.vraptor.core.BaseComponents;
import br.com.caelum.vraptor.deserialization.Deserializer;
import br.com.caelum.vraptor.deserialization.Deserializers;
import br.com.caelum.vraptor.deserialization.Deserializes;
import br.com.caelum.vraptor.ioc.ApplicationScoped;
import br.com.caelum.vraptor.ioc.Container;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ApplicationScoped
public class DefaultDeserializers
implements Deserializers {
    private final Map<String, Class<? extends Deserializer>> deserializers = new HashMap<String, Class<? extends Deserializer>>();

    public DefaultDeserializers() {
        for (Class<? extends Deserializer> type : BaseComponents.getDeserializers()) {
            this.register(type);
        }
    }

    @Override
    public Deserializer deserializerFor(String contentType, Container container) {
        if (this.deserializers.containsKey(contentType)) {
            return container.instanceFor(this.deserializers.get(contentType));
        }
        return this.subpathDeserializerFor(contentType, container);
    }

    private Deserializer subpathDeserializerFor(String contentType, Container container) {
        String newType;
        if (contentType.contains("/") && this.deserializers.containsKey(newType = this.removeChar(contentType, "/"))) {
            return container.instanceFor(this.deserializers.get(newType));
        }
        return this.subpathDeserializerForPlus(contentType, container);
    }

    private Deserializer subpathDeserializerForPlus(String contentType, Container container) {
        String newType;
        if (contentType.contains("+") && this.deserializers.containsKey(newType = this.removeChar(contentType, "+"))) {
            return container.instanceFor(this.deserializers.get(newType));
        }
        return null;
    }

    private String removeChar(String type, String by) {
        return type.substring(type.lastIndexOf(by) + 1);
    }

    @Override
    public void register(Class<? extends Deserializer> type) {
        String[] contentTypes;
        if (!type.isAnnotationPresent(Deserializes.class)) {
            throw new IllegalArgumentException("You must annotate your deserializers with @Deserializes");
        }
        for (String contentType : contentTypes = type.getAnnotation(Deserializes.class).value()) {
            this.deserializers.put(contentType, type);
        }
    }
}

