/*
 * Decompiled with CFR 0.152.
 */
package br.com.caelum.vraptor.core;

import com.google.common.base.Preconditions;
import java.util.Enumeration;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SafeResourceBundle
extends ResourceBundle {
    private final ResourceBundle delegate;
    private final boolean isDefault;

    public SafeResourceBundle(ResourceBundle delegate) {
        this(delegate, false);
    }

    public SafeResourceBundle(ResourceBundle delegate, boolean isDefault) {
        Preconditions.checkNotNull((Object)delegate, (Object)"Bundle should not be null. Please report it to VRaptor devs.");
        this.delegate = delegate;
        this.isDefault = isDefault;
    }

    public boolean isDefault() {
        return this.isDefault;
    }

    @Override
    public Enumeration<String> getKeys() {
        return this.delegate.getKeys();
    }

    @Override
    protected Object handleGetObject(String key) {
        try {
            return this.delegate.getString(key);
        }
        catch (MissingResourceException e) {
            return "???" + key + "???";
        }
    }
}

