/*
 * Decompiled with CFR 0.152.
 */
package br.com.caelum.vraptor.core;

import br.com.caelum.vraptor.Result;
import br.com.caelum.vraptor.View;
import br.com.caelum.vraptor.core.AbstractResult;
import br.com.caelum.vraptor.core.ExceptionMapper;
import br.com.caelum.vraptor.interceptor.TypeNameExtractor;
import br.com.caelum.vraptor.ioc.Container;
import br.com.caelum.vraptor.ioc.RequestScoped;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@RequestScoped
public class DefaultResult
extends AbstractResult {
    private final HttpServletRequest request;
    private final Container container;
    private final Map<String, Object> includedAttributes;
    private boolean responseCommitted = false;
    private final ExceptionMapper exceptions;
    private final TypeNameExtractor extractor;

    public DefaultResult(HttpServletRequest request, Container container, ExceptionMapper exceptions, TypeNameExtractor extractor) {
        this.request = request;
        this.container = container;
        this.extractor = extractor;
        this.includedAttributes = new HashMap<String, Object>();
        this.exceptions = exceptions;
    }

    @Override
    public <T extends View> T use(Class<T> view) {
        this.responseCommitted = true;
        return (T)((View)this.container.instanceFor(view));
    }

    @Override
    public Result on(Class<? extends Exception> exception) {
        return this.exceptions.record(exception);
    }

    @Override
    public Result include(String key, Object value) {
        this.includedAttributes.put(key, value);
        this.request.setAttribute(key, value);
        return this;
    }

    @Override
    public boolean used() {
        return this.responseCommitted;
    }

    @Override
    public Map<String, Object> included() {
        return Collections.unmodifiableMap(this.includedAttributes);
    }

    @Override
    public Result include(Object value) {
        if (value == null) {
            return this;
        }
        String key = this.extractor.nameFor(value.getClass());
        return this.include(key, value);
    }
}

