/*
 * Decompiled with CFR 0.152.
 */
package br.com.caelum.vraptor.core;

import br.com.caelum.vraptor.Lazy;
import br.com.caelum.vraptor.core.InterceptorHandler;
import br.com.caelum.vraptor.core.InterceptorHandlerFactory;
import br.com.caelum.vraptor.core.LazyInterceptorHandler;
import br.com.caelum.vraptor.core.ToInstantiateInterceptorHandler;
import br.com.caelum.vraptor.interceptor.Interceptor;
import br.com.caelum.vraptor.ioc.ApplicationScoped;
import br.com.caelum.vraptor.ioc.Container;
import com.google.common.collect.MapMaker;
import java.util.concurrent.ConcurrentMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ApplicationScoped
public class DefaultInterceptorHandlerFactory
implements InterceptorHandlerFactory {
    private Container container;
    private ConcurrentMap<Class<? extends Interceptor>, InterceptorHandler> cachedHandlers = new MapMaker().makeMap();

    public DefaultInterceptorHandlerFactory(Container container) {
        this.container = container;
    }

    @Override
    public InterceptorHandler handlerFor(Class<? extends Interceptor> type) {
        if (type.isAnnotationPresent(Lazy.class)) {
            InterceptorHandler handler = (InterceptorHandler)this.cachedHandlers.get(type);
            if (handler == null) {
                LazyInterceptorHandler value = new LazyInterceptorHandler(this.container, type);
                this.cachedHandlers.putIfAbsent(type, value);
                return value;
            }
            return handler;
        }
        return new ToInstantiateInterceptorHandler(this.container, type);
    }
}

