/*
 * Decompiled with CFR 0.152.
 */
package br.com.caelum.vraptor.converter.jodatime;

import br.com.caelum.vraptor.core.Localization;
import com.google.common.base.Strings;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Date;
import java.util.Locale;
import org.joda.time.LocalDateTime;
import org.joda.time.LocalTime;
import org.joda.time.base.BaseLocal;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class LocaleBasedJodaTimeConverter {
    private final Localization localization;

    public LocaleBasedJodaTimeConverter(Localization localization) {
        this.localization = localization;
    }

    public Date convert(String value, Class<? extends BaseLocal> type) throws ParseException {
        if (Strings.isNullOrEmpty((String)value)) {
            return null;
        }
        return this.getDateFormat(type).parse(value);
    }

    public Locale getLocale() {
        Locale locale = this.localization.getLocale();
        if (locale == null) {
            locale = Locale.getDefault();
        }
        return locale;
    }

    private DateFormat getDateFormat(Class<? extends BaseLocal> type) {
        if (type.equals(LocalTime.class)) {
            return DateFormat.getTimeInstance(3, this.getLocale());
        }
        if (type.equals(LocalDateTime.class)) {
            return DateFormat.getDateTimeInstance(3, 3, this.getLocale());
        }
        return DateFormat.getDateInstance(3, this.getLocale());
    }
}

