/*
 * Decompiled with CFR 0.152.
 */
package br.com.caelum.vraptor.converter.jodatime;

import br.com.caelum.vraptor.Convert;
import br.com.caelum.vraptor.Converter;
import br.com.caelum.vraptor.converter.ConversionError;
import br.com.caelum.vraptor.converter.jodatime.LocaleBasedJodaTimeConverter;
import br.com.caelum.vraptor.core.Localization;
import java.text.MessageFormat;
import java.util.Date;
import java.util.ResourceBundle;
import org.joda.time.LocalTime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Convert(value=LocalTime.class)
public class LocalTimeConverter
implements Converter<LocalTime> {
    private final Localization localization;

    public LocalTimeConverter(Localization localization) {
        this.localization = localization;
    }

    @Override
    public LocalTime convert(String value, Class<? extends LocalTime> type, ResourceBundle bundle) {
        try {
            Date time = new LocaleBasedJodaTimeConverter(this.localization).convert(value, type);
            if (time == null) {
                return null;
            }
            return LocalTime.fromDateFields((Date)time);
        }
        catch (Exception e) {
            throw new ConversionError(MessageFormat.format(bundle.getString("is_not_a_valid_time"), value));
        }
    }
}

