/*
 * Decompiled with CFR 0.152.
 */
package br.com.caelum.vraptor.converter.jodatime;

import br.com.caelum.vraptor.Convert;
import br.com.caelum.vraptor.Converter;
import br.com.caelum.vraptor.converter.ConversionError;
import br.com.caelum.vraptor.converter.jodatime.LocaleBasedJodaTimeConverter;
import br.com.caelum.vraptor.core.Localization;
import java.text.MessageFormat;
import java.util.Date;
import java.util.ResourceBundle;
import org.joda.time.LocalDateTime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Convert(value=LocalDateTime.class)
public class LocalDateTimeConverter
implements Converter<LocalDateTime> {
    private final Localization localization;

    public LocalDateTimeConverter(Localization localization) {
        this.localization = localization;
    }

    @Override
    public LocalDateTime convert(String value, Class<? extends LocalDateTime> type, ResourceBundle bundle) {
        try {
            Date datetime = new LocaleBasedJodaTimeConverter(this.localization).convert(value, type);
            if (datetime == null) {
                return null;
            }
            return LocalDateTime.fromDateFields((Date)datetime);
        }
        catch (Exception e) {
            throw new ConversionError(MessageFormat.format(bundle.getString("is_not_a_valid_datetime"), value));
        }
    }
}

