/*
 * Decompiled with CFR 0.152.
 */
package br.com.caelum.vraptor;

import br.com.caelum.vraptor.config.BasicConfiguration;
import br.com.caelum.vraptor.core.DefaultStaticContentHandler;
import br.com.caelum.vraptor.core.Execution;
import br.com.caelum.vraptor.core.RequestExecution;
import br.com.caelum.vraptor.core.RequestInfo;
import br.com.caelum.vraptor.core.StaticContentHandler;
import br.com.caelum.vraptor.http.EncodingHandler;
import br.com.caelum.vraptor.http.VRaptorRequest;
import br.com.caelum.vraptor.http.VRaptorResponse;
import br.com.caelum.vraptor.ioc.Container;
import br.com.caelum.vraptor.ioc.ContainerProvider;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VRaptor
implements Filter {
    private ContainerProvider provider;
    private ServletContext servletContext;
    private StaticContentHandler staticHandler;
    private static final Logger logger = LoggerFactory.getLogger(VRaptor.class);

    public void destroy() {
        this.provider.stop();
        this.provider = null;
        this.servletContext = null;
    }

    public void doFilter(ServletRequest req, ServletResponse res, FilterChain chain) throws IOException, ServletException {
        if (!(req instanceof HttpServletRequest) || !(res instanceof HttpServletResponse)) {
            throw new ServletException("VRaptor must be run inside a Servlet environment. Portlets and others aren't supported.");
        }
        final HttpServletRequest baseRequest = (HttpServletRequest)req;
        final HttpServletResponse baseResponse = (HttpServletResponse)res;
        if (this.staticHandler.requestingStaticFile(baseRequest)) {
            this.staticHandler.deferProcessingToContainer(chain, baseRequest, baseResponse);
        } else {
            logger.debug("VRaptor received a new request");
            logger.trace("Request: {}", (Object)req);
            VRaptorRequest mutableRequest = new VRaptorRequest(baseRequest);
            VRaptorResponse mutableResponse = new VRaptorResponse(baseResponse);
            RequestInfo request = new RequestInfo(this.servletContext, chain, mutableRequest, mutableResponse);
            this.provider.provideForRequest(request, new Execution<Object>(){

                @Override
                public Object insideRequest(Container container) {
                    container.instanceFor(EncodingHandler.class).setEncoding(baseRequest, baseResponse);
                    container.instanceFor(RequestExecution.class).execute();
                    return null;
                }
            });
            logger.debug("VRaptor ended the request");
        }
    }

    public void init(FilterConfig cfg) throws ServletException {
        this.servletContext = cfg.getServletContext();
        BasicConfiguration config = new BasicConfiguration(this.servletContext);
        this.init(config.getProvider(), new DefaultStaticContentHandler(this.servletContext));
        logger.info("VRaptor 3.4.0 successfuly initialized");
    }

    void init(ContainerProvider provider, StaticContentHandler handler) {
        this.provider = provider;
        this.staticHandler = handler;
        this.provider.start(this.servletContext);
    }
}

