/*
 * Decompiled with CFR 0.152.
 */
package com.lambdaworks.redis.support;

import com.lambdaworks.redis.RedisException;
import com.lambdaworks.redis.api.StatefulConnection;
import com.lambdaworks.redis.internal.AbstractInvocationHandler;
import com.lambdaworks.redis.internal.LettuceAssert;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import org.apache.commons.pool2.BasePooledObjectFactory;
import org.apache.commons.pool2.ObjectPool;
import org.apache.commons.pool2.PooledObject;
import org.apache.commons.pool2.impl.DefaultPooledObject;
import org.apache.commons.pool2.impl.GenericObjectPool;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.apache.commons.pool2.impl.SoftReferenceObjectPool;

public abstract class ConnectionPoolSupport {
    private ConnectionPoolSupport() {
    }

    public static <T extends StatefulConnection<?, ?>> GenericObjectPool<T> createGenericObjectPool(Supplier<T> connectionSupplier, GenericObjectPoolConfig config) {
        return ConnectionPoolSupport.createGenericObjectPool(connectionSupplier, config, true);
    }

    public static <T extends StatefulConnection<?, ?>> GenericObjectPool<T> createGenericObjectPool(Supplier<T> connectionSupplier, GenericObjectPoolConfig config, boolean wrapConnections) {
        LettuceAssert.notNull(connectionSupplier, "Connection supplier must not be null");
        LettuceAssert.notNull(config, "GenericObjectPoolConfig must not be null");
        AtomicReference<ObjectPool<T>> poolRef = new AtomicReference<ObjectPool<T>>();
        Supplier<T> providerToUse = wrapConnections ? ConnectionPoolSupport.wrappedConnectionSupplier(connectionSupplier, poolRef) : connectionSupplier;
        GenericObjectPool pool = new GenericObjectPool(new RedisPooledObjectFactory<T>(providerToUse), config);
        poolRef.set((ObjectPool<T>)pool);
        return pool;
    }

    public static <T extends StatefulConnection<?, ?>> SoftReferenceObjectPool<T> createSoftReferenceObjectPool(Supplier<T> connectionSupplier) {
        return ConnectionPoolSupport.createSoftReferenceObjectPool(connectionSupplier, true);
    }

    public static <T extends StatefulConnection<?, ?>> SoftReferenceObjectPool<T> createSoftReferenceObjectPool(Supplier<T> connectionSupplier, boolean wrapConnections) {
        LettuceAssert.notNull(connectionSupplier, "Connection supplier must not be null");
        AtomicReference<ObjectPool<T>> poolRef = new AtomicReference<ObjectPool<T>>();
        Supplier<T> providerToUse = wrapConnections ? ConnectionPoolSupport.wrappedConnectionSupplier(connectionSupplier, poolRef) : connectionSupplier;
        SoftReferenceObjectPool pool = new SoftReferenceObjectPool(new RedisPooledObjectFactory<T>(providerToUse));
        poolRef.set((ObjectPool<T>)pool);
        return pool;
    }

    private static <T> Supplier<T> wrappedConnectionSupplier(final Supplier<T> connectionSupplier, final AtomicReference<ObjectPool<T>> poolRef) {
        return new Supplier<T>(){

            @Override
            public T get() {
                Object connection = connectionSupplier.get();
                ReturnObjectOnCloseInvocationHandler<Object> handler = new ReturnObjectOnCloseInvocationHandler<Object>(connection, (ObjectPool)poolRef.get());
                Object proxiedConnection = Proxy.newProxyInstance(this.getClass().getClassLoader(), connection.getClass().getInterfaces(), handler);
                handler.setProxiedConnection(proxiedConnection);
                return proxiedConnection;
            }
        };
    }

    private static class DelegateCloseToConnectionInvocationHandler<T extends AutoCloseable>
    extends AbstractInvocationHandler {
        private final T proxiedConnection;
        private final Object api;

        DelegateCloseToConnectionInvocationHandler(T proxiedConnection, Object api) {
            this.proxiedConnection = proxiedConnection;
            this.api = api;
        }

        @Override
        protected Object handleInvocation(Object proxy, Method method, Object[] args) throws Throwable {
            if (method.getName().equals("getStatefulConnection")) {
                return this.proxiedConnection;
            }
            try {
                if (method.getName().equals("close")) {
                    this.proxiedConnection.close();
                    return null;
                }
                return method.invoke(this.api, args);
            }
            catch (InvocationTargetException e) {
                throw e.getTargetException();
            }
        }
    }

    private static class ReturnObjectOnCloseInvocationHandler<T>
    extends AbstractInvocationHandler {
        private T connection;
        private T proxiedConnection;
        private Map<Method, Object> connectionProxies = new ConcurrentHashMap<Method, Object>(5, 1.0f);
        private final ObjectPool<T> pool;

        ReturnObjectOnCloseInvocationHandler(T connection, ObjectPool<T> pool) {
            this.connection = connection;
            this.pool = pool;
        }

        void setProxiedConnection(T proxiedConnection) {
            this.proxiedConnection = proxiedConnection;
        }

        @Override
        protected Object handleInvocation(Object proxy, Method method, Object[] args) throws Throwable {
            if (method.getName().equals("getStatefulConnection")) {
                return this.proxiedConnection;
            }
            if (this.connection == null) {
                throw new RedisException("Connection is deallocated and cannot be used anymore.");
            }
            if (method.getName().equals("close")) {
                this.pool.returnObject(this.proxiedConnection);
                this.connection = null;
                this.proxiedConnection = null;
                this.connectionProxies.clear();
                return null;
            }
            try {
                if (method.getName().equals("sync") || method.getName().equals("async") || method.getName().equals("reactive")) {
                    return this.connectionProxies.computeIfAbsent(method, m -> {
                        try {
                            Object result = method.invoke(this.connection, args);
                            result = Proxy.newProxyInstance(this.getClass().getClassLoader(), result.getClass().getInterfaces(), new DelegateCloseToConnectionInvocationHandler<AutoCloseable>((AutoCloseable)this.proxiedConnection, result));
                            return result;
                        }
                        catch (IllegalAccessException e) {
                            throw new RedisException(e);
                        }
                        catch (InvocationTargetException e) {
                            throw new RedisException(e.getTargetException());
                        }
                    });
                }
                return method.invoke(this.connection, args);
            }
            catch (InvocationTargetException e) {
                throw e.getTargetException();
            }
        }

        public T getConnection() {
            return this.connection;
        }
    }

    private static class RedisPooledObjectFactory<T extends StatefulConnection<?, ?>>
    extends BasePooledObjectFactory<T> {
        private final Supplier<T> connectionSupplier;

        RedisPooledObjectFactory(Supplier<T> connectionSupplier) {
            this.connectionSupplier = connectionSupplier;
        }

        public T create() throws Exception {
            return (T)((StatefulConnection)this.connectionSupplier.get());
        }

        public PooledObject<T> wrap(T obj) {
            return new DefaultPooledObject(obj);
        }

        public boolean validateObject(PooledObject<T> p) {
            return ((StatefulConnection)p.getObject()).isOpen();
        }
    }
}

