/*
 * Decompiled with CFR 0.152.
 */
package com.lambdaworks.redis.sentinel;

import com.lambdaworks.redis.AbstractRedisReactiveCommands;
import com.lambdaworks.redis.api.StatefulConnection;
import com.lambdaworks.redis.codec.RedisCodec;
import com.lambdaworks.redis.internal.LettuceAssert;
import com.lambdaworks.redis.sentinel.SentinelCommandBuilder;
import com.lambdaworks.redis.sentinel.api.StatefulRedisSentinelConnection;
import com.lambdaworks.redis.sentinel.api.reactive.RedisSentinelReactiveCommands;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Map;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class RedisSentinelReactiveCommandsImpl<K, V>
extends AbstractRedisReactiveCommands<K, V>
implements RedisSentinelReactiveCommands<K, V> {
    private final SentinelCommandBuilder<K, V> commandBuilder;
    private final StatefulConnection<K, V> connection;

    public RedisSentinelReactiveCommandsImpl(StatefulConnection<K, V> connection, RedisCodec<K, V> codec) {
        super(connection, codec);
        this.connection = connection;
        this.commandBuilder = new SentinelCommandBuilder<K, V>(codec);
    }

    @Override
    public Mono<SocketAddress> getMasterAddrByName(K key) {
        Flux flux = this.createDissolvingFlux(() -> this.commandBuilder.getMasterAddrByKey(key));
        return flux.collectList().flatMap(list -> {
            if (list.isEmpty()) {
                return Flux.empty();
            }
            LettuceAssert.isTrue(list.size() == 2, "List must contain exact 2 entries (Hostname, Port)");
            String hostname = (String)list.get(0);
            String port = (String)list.get(1);
            return Mono.just((Object)new InetSocketAddress(hostname, Integer.parseInt(port)));
        }).cast(SocketAddress.class).next();
    }

    @Override
    public Flux<Map<K, V>> masters() {
        return this.createDissolvingFlux(this.commandBuilder::masters);
    }

    @Override
    public Mono<Map<K, V>> master(K key) {
        return this.createMono(() -> this.commandBuilder.master(key));
    }

    @Override
    public Flux<Map<K, V>> slaves(K key) {
        return this.createDissolvingFlux(() -> this.commandBuilder.slaves(key));
    }

    @Override
    public Mono<Long> reset(K key) {
        return this.createMono(() -> this.commandBuilder.reset(key));
    }

    @Override
    public Mono<String> failover(K key) {
        return this.createMono(() -> this.commandBuilder.failover(key));
    }

    @Override
    public Mono<String> monitor(K key, String ip, int port, int quorum) {
        return this.createMono(() -> this.commandBuilder.monitor(key, ip, port, quorum));
    }

    @Override
    public Mono<String> set(K key, String option, V value) {
        return this.createMono(() -> this.commandBuilder.set(key, option, value));
    }

    @Override
    public Mono<String> remove(K key) {
        return this.createMono(() -> this.commandBuilder.remove(key));
    }

    @Override
    public Mono<String> ping() {
        return this.createMono(this.commandBuilder::ping);
    }

    @Override
    public void close() {
        this.connection.close();
    }

    @Override
    public boolean isOpen() {
        return this.connection.isOpen();
    }

    @Override
    public StatefulRedisSentinelConnection<K, V> getStatefulConnection() {
        return (StatefulRedisSentinelConnection)this.connection;
    }
}

