/*
 * Decompiled with CFR 0.152.
 */
package com.lambdaworks.redis.pubsub;

import com.lambdaworks.redis.RedisChannelWriter;
import com.lambdaworks.redis.RedisFuture;
import com.lambdaworks.redis.StatefulRedisConnectionImpl;
import com.lambdaworks.redis.codec.RedisCodec;
import com.lambdaworks.redis.pubsub.PubSubEndpoint;
import com.lambdaworks.redis.pubsub.RedisPubSubAsyncCommandsImpl;
import com.lambdaworks.redis.pubsub.RedisPubSubListener;
import com.lambdaworks.redis.pubsub.RedisPubSubReactiveCommandsImpl;
import com.lambdaworks.redis.pubsub.StatefulRedisPubSubConnection;
import com.lambdaworks.redis.pubsub.api.async.RedisPubSubAsyncCommands;
import com.lambdaworks.redis.pubsub.api.reactive.RedisPubSubReactiveCommands;
import com.lambdaworks.redis.pubsub.api.sync.RedisPubSubCommands;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class StatefulRedisPubSubConnectionImpl<K, V>
extends StatefulRedisConnectionImpl<K, V>
implements StatefulRedisPubSubConnection<K, V> {
    private final PubSubEndpoint<K, V> endpoint;

    public StatefulRedisPubSubConnectionImpl(PubSubEndpoint<K, V> endpoint, RedisChannelWriter writer, RedisCodec<K, V> codec, long timeout, TimeUnit unit) {
        super(writer, codec, timeout, unit);
        this.endpoint = endpoint;
    }

    @Override
    public void addListener(RedisPubSubListener<K, V> listener) {
        this.endpoint.addListener(listener);
    }

    @Override
    public void removeListener(RedisPubSubListener<K, V> listener) {
        this.endpoint.removeListener(listener);
    }

    @Override
    public RedisPubSubAsyncCommands<K, V> async() {
        return (RedisPubSubAsyncCommands)((Object)this.async);
    }

    @Override
    protected RedisPubSubAsyncCommandsImpl<K, V> newRedisAsyncCommandsImpl() {
        return new RedisPubSubAsyncCommandsImpl(this, this.codec);
    }

    @Override
    public RedisPubSubCommands<K, V> sync() {
        return (RedisPubSubCommands)this.sync;
    }

    @Override
    protected RedisPubSubCommands<K, V> newRedisSyncCommandsImpl() {
        return (RedisPubSubCommands)this.syncHandler(this.async(), RedisPubSubCommands.class);
    }

    @Override
    public RedisPubSubReactiveCommands<K, V> reactive() {
        return (RedisPubSubReactiveCommands)((Object)this.reactive);
    }

    @Override
    protected RedisPubSubReactiveCommandsImpl<K, V> newRedisReactiveCommandsImpl() {
        return new RedisPubSubReactiveCommandsImpl(this, this.codec);
    }

    protected List<RedisFuture<Void>> resubscribe() {
        ArrayList<RedisFuture<Void>> result = new ArrayList<RedisFuture<Void>>();
        if (!this.endpoint.getChannels().isEmpty()) {
            result.add(this.async().subscribe(this.toArray(this.endpoint.getChannels())));
        }
        if (!this.endpoint.getPatterns().isEmpty()) {
            result.add(this.async().psubscribe(this.toArray(this.endpoint.getPatterns())));
        }
        return result;
    }

    private <T> T[] toArray(Collection<T> c) {
        Class<?> cls = c.iterator().next().getClass();
        Object[] array = (Object[])Array.newInstance(cls, c.size());
        return c.toArray(array);
    }

    @Override
    public void activated() {
        super.activated();
        this.resubscribe();
    }
}

