/*
 * Decompiled with CFR 0.152.
 */
package com.lambdaworks.redis.pubsub;

import com.lambdaworks.redis.codec.RedisCodec;
import com.lambdaworks.redis.output.CommandOutput;
import com.lambdaworks.redis.protocol.CommandHandler;
import com.lambdaworks.redis.pubsub.PubSubEndpoint;
import com.lambdaworks.redis.pubsub.PubSubOutput;
import com.lambdaworks.redis.resource.ClientResources;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;

public class PubSubCommandHandler<K, V>
extends CommandHandler {
    private final PubSubEndpoint<K, V> endpoint;
    private final RedisCodec<K, V> codec;
    private PubSubOutput<K, V, V> output;

    public PubSubCommandHandler(ClientResources clientResources, RedisCodec<K, V> codec, PubSubEndpoint<K, V> endpoint) {
        super(clientResources, endpoint);
        this.codec = codec;
        this.output = new PubSubOutput(codec);
        this.endpoint = endpoint;
    }

    @Override
    protected void decode(ChannelHandlerContext ctx, ByteBuf buffer) throws InterruptedException {
        while (this.output.type() == null && !this.getQueue().isEmpty()) {
            CommandOutput<?, ?, ?> currentOutput = this.getQueue().peek().getOutput();
            if (!super.decode(buffer, currentOutput)) {
                return;
            }
            this.getQueue().poll().complete();
            buffer.discardReadBytes();
            if (!(currentOutput instanceof PubSubOutput)) continue;
            this.endpoint.notifyMessage((PubSubOutput)currentOutput);
        }
        while (super.decode(buffer, this.output)) {
            this.endpoint.notifyMessage(this.output);
            this.output = new PubSubOutput(this.codec);
            buffer.discardReadBytes();
        }
    }
}

