/*
 * Decompiled with CFR 0.152.
 */
package com.lambdaworks.redis.protocol;

import com.lambdaworks.redis.internal.LettuceAssert;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Supplier;

class SharedLock {
    private final AtomicLong writers = new AtomicLong();
    private volatile Thread exclusiveLockOwner;

    SharedLock() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void incrementWriters() {
        if (this.exclusiveLockOwner == Thread.currentThread()) {
            return;
        }
        SharedLock sharedLock = this;
        synchronized (sharedLock) {
            while (this.writers.get() < 0L) {
            }
            this.writers.incrementAndGet();
            return;
        }
    }

    void decrementWriters() {
        if (this.exclusiveLockOwner == Thread.currentThread()) {
            return;
        }
        this.writers.decrementAndGet();
    }

    void doExclusive(Runnable runnable) {
        LettuceAssert.notNull(runnable, "Runnable must not be null");
        this.doExclusive(() -> {
            runnable.run();
            return null;
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    <T> T doExclusive(Supplier<T> supplier) {
        LettuceAssert.notNull(supplier, "Supplier must not be null");
        SharedLock sharedLock = this;
        synchronized (sharedLock) {
            this.lockWritersExclusive();
            T t = supplier.get();
            return t;
            finally {
                this.unlockWritersExclusive();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void lockWritersExclusive() {
        if (this.exclusiveLockOwner == Thread.currentThread()) {
            this.writers.decrementAndGet();
            return;
        }
        SharedLock sharedLock = this;
        synchronized (sharedLock) {
            while (!this.writers.compareAndSet(0L, -1L)) {
            }
            this.exclusiveLockOwner = Thread.currentThread();
            return;
        }
    }

    private void unlockWritersExclusive() {
        if (this.exclusiveLockOwner == Thread.currentThread() && this.writers.incrementAndGet() == 0L) {
            this.exclusiveLockOwner = null;
        }
    }
}

