/*
 * Decompiled with CFR 0.152.
 */
package com.lambdaworks.redis.protocol;

import com.lambdaworks.redis.ClientOptions;
import com.lambdaworks.redis.RedisChannelInitializer;
import com.lambdaworks.redis.internal.LettuceAssert;
import com.lambdaworks.redis.protocol.ChannelLogDescriptor;
import com.lambdaworks.redis.protocol.ConnectionFacade;
import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.util.internal.logging.InternalLogLevel;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.net.SocketAddress;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Supplier;

class ReconnectionHandler {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(ReconnectionHandler.class);
    private final Supplier<SocketAddress> socketAddressSupplier;
    private final ClientOptions clientOptions;
    private final Bootstrap bootstrap;
    private final ConnectionFacade connectionFacade;
    private TimeUnit timeoutUnit = TimeUnit.SECONDS;
    private long timeout = 60L;
    private volatile ChannelFuture currentFuture;
    private volatile boolean reconnectSuspended;

    ReconnectionHandler(ClientOptions clientOptions, Bootstrap bootstrap, Supplier<SocketAddress> socketAddressSupplier, ConnectionFacade connectionFacade) {
        LettuceAssert.notNull(socketAddressSupplier, "SocketAddressSupplier must not be null");
        LettuceAssert.notNull(clientOptions, "ClientOptions must not be null");
        LettuceAssert.notNull(bootstrap, "Bootstrap must not be null");
        LettuceAssert.notNull(connectionFacade, "ConnectionFacade must not be null");
        this.socketAddressSupplier = socketAddressSupplier;
        this.bootstrap = bootstrap;
        this.clientOptions = clientOptions;
        this.connectionFacade = connectionFacade;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean reconnect(InternalLogLevel infoLevel) throws Exception {
        SocketAddress remoteAddress = this.socketAddressSupplier.get();
        try {
            long timeLeft = this.timeoutUnit.toNanos(this.timeout);
            long start = System.nanoTime();
            logger.debug("Reconnecting to Redis at {}", (Object)remoteAddress);
            this.currentFuture = this.bootstrap.connect(remoteAddress);
            if (!this.currentFuture.await(timeLeft, TimeUnit.NANOSECONDS)) {
                if (this.currentFuture.isCancellable()) {
                    this.currentFuture.cancel(true);
                }
                throw new TimeoutException("Reconnection attempt exceeded timeout of " + this.timeout + " " + (Object)((Object)this.timeoutUnit));
            }
            this.currentFuture.sync();
            Channel channel = this.currentFuture.channel();
            RedisChannelInitializer channelInitializer = (RedisChannelInitializer)channel.pipeline().get(RedisChannelInitializer.class);
            if (channelInitializer == null) {
                logger.warn("Reconnection attempt without a RedisChannelInitializer in the channel pipeline");
                this.close(channel);
                boolean bl = false;
                return bl;
            }
            channelInitializer.channelInitialized().get(Math.max(0L, timeLeft -= System.nanoTime() - start), TimeUnit.NANOSECONDS);
            if (logger.isDebugEnabled()) {
                logger.log(infoLevel, "Reconnected to {}, Channel {}", (Object)remoteAddress, (Object)ChannelLogDescriptor.logDescriptor(channel));
            } else {
                logger.log(infoLevel, "Reconnected to {}", (Object)remoteAddress);
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this.currentFuture = null;
        }
    }

    private void close(Channel channel) {
        if (channel != null && channel.isOpen()) {
            channel.close();
        }
    }

    boolean isReconnectSuspended() {
        return this.reconnectSuspended;
    }

    void setReconnectSuspended(boolean reconnectSuspended) {
        this.reconnectSuspended = reconnectSuspended;
    }

    long getTimeout() {
        return this.timeout;
    }

    void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    void prepareClose() {
        if (this.currentFuture != null && !this.currentFuture.isDone()) {
            this.currentFuture.cancel(true);
        }
    }

    ClientOptions getClientOptions() {
        return this.clientOptions;
    }
}

