/*
 * Decompiled with CFR 0.152.
 */
package com.lambdaworks.redis.protocol;

import com.lambdaworks.redis.protocol.HasQueuedCommands;
import com.lambdaworks.redis.protocol.RedisCommand;
import io.netty.util.internal.ConcurrentSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;

class QueuedCommands {
    private Set<HasQueuedCommands> queues = new ConcurrentSet();

    QueuedCommands() {
    }

    void register(HasQueuedCommands queueHolder) {
        this.queues.add(queueHolder);
    }

    void unregister(HasQueuedCommands queueHolder) {
        this.queues.remove(queueHolder);
    }

    public void remove(RedisCommand<?, ?, ?> command) {
        for (HasQueuedCommands queue : this.queues) {
            queue.getQueue().remove(command);
        }
    }

    void removeAll(Collection<? extends RedisCommand<?, ?, ?>> commands) {
        for (HasQueuedCommands queue : this.queues) {
            queue.getQueue().removeAll(commands);
        }
    }

    List<RedisCommand<?, ?, ?>> drainCommands() {
        int size = 0;
        for (HasQueuedCommands queue : this.queues) {
            size += queue.getQueue().size();
        }
        ArrayList target = new ArrayList(size);
        for (HasQueuedCommands queue : this.queues) {
            RedisCommand<?, ?, ?> cmd;
            while ((cmd = queue.getQueue().poll()) != null) {
                target.add(cmd);
            }
        }
        return target;
    }

    boolean exceedsLimit(int requestQueueSize) {
        if (requestQueueSize == Integer.MAX_VALUE) {
            return false;
        }
        int current = 0;
        for (HasQueuedCommands queue : this.queues) {
            if ((current += queue.getQueue().size()) < requestQueueSize) continue;
            return true;
        }
        return false;
    }
}

