/*
 * Decompiled with CFR 0.152.
 */
package com.lambdaworks.redis.protocol;

import com.lambdaworks.redis.ClientOptions;
import com.lambdaworks.redis.ConnectionEvents;
import com.lambdaworks.redis.RedisChannelWriter;
import com.lambdaworks.redis.RedisException;
import com.lambdaworks.redis.internal.LettuceAssert;
import com.lambdaworks.redis.internal.LettuceFactories;
import com.lambdaworks.redis.protocol.ChannelLogDescriptor;
import com.lambdaworks.redis.protocol.CommandHandler;
import com.lambdaworks.redis.protocol.ConnectionFacade;
import com.lambdaworks.redis.protocol.ConnectionWatchdog;
import com.lambdaworks.redis.protocol.Endpoint;
import com.lambdaworks.redis.protocol.HasQueuedCommands;
import com.lambdaworks.redis.protocol.QueuedCommands;
import com.lambdaworks.redis.protocol.RedisCommand;
import com.lambdaworks.redis.protocol.SharedLock;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.internal.logging.InternalLogLevel;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.io.IOException;
import java.nio.channels.ClosedChannelException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.List;
import java.util.Optional;
import java.util.Queue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Supplier;

public class DefaultEndpoint
implements RedisChannelWriter,
Endpoint,
HasQueuedCommands {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(DefaultEndpoint.class);
    private static final AtomicLong ENDPOINT_COUNTER = new AtomicLong();
    private final long endpointId = ENDPOINT_COUNTER.incrementAndGet();
    private final AtomicBoolean closed = new AtomicBoolean();
    private final Deque<RedisCommand<?, ?, ?>> commandBuffer = LettuceFactories.newConcurrentQueue();
    private final SharedLock sharedLock = new SharedLock();
    private final Reliability reliability;
    private final ClientOptions clientOptions;
    private final QueuedCommands queuedCommands = new QueuedCommands();
    private final boolean traceEnabled = logger.isTraceEnabled();
    private final boolean debugEnabled = logger.isDebugEnabled();
    protected volatile Channel channel;
    private String logPrefix;
    private boolean autoFlushCommands = true;
    private ConnectionWatchdog connectionWatchdog;
    private ConnectionFacade connectionFacade;
    private Throwable connectionError;

    public DefaultEndpoint(ClientOptions clientOptions) {
        LettuceAssert.notNull(clientOptions, "ClientOptions must not be null");
        this.clientOptions = clientOptions;
        this.reliability = clientOptions.isAutoReconnect() ? Reliability.AT_LEAST_ONCE : Reliability.AT_MOST_ONCE;
        this.queuedCommands.register(this);
    }

    @Override
    public <K, V, T> RedisCommand<K, V, T> write(RedisCommand<K, V, T> command) {
        LettuceAssert.notNull(command, "Command must not be null");
        try {
            this.sharedLock.incrementWriters();
            if (this.isClosed()) {
                throw new RedisException("Connection is closed");
            }
            if (this.queuedCommands.exceedsLimit(this.clientOptions.getRequestQueueSize())) {
                throw new RedisException("Request queue size exceeded: " + this.clientOptions.getRequestQueueSize() + ". Commands are not accepted until the queue size drops.");
            }
            if ((this.channel == null || !this.isConnected()) && this.isRejectCommand()) {
                throw new RedisException("Currently not connected. Commands are rejected.");
            }
            if (this.autoFlushCommands) {
                if (this.isConnected()) {
                    this.writeToChannel(command);
                } else {
                    this.writeToBuffer(command);
                }
            } else {
                this.writeToBuffer(command);
            }
        }
        finally {
            this.sharedLock.decrementWriters();
            if (this.debugEnabled) {
                logger.debug("{} write() done", (Object)this.logPrefix());
            }
        }
        return command;
    }

    private <C extends RedisCommand<?, ?, T>, T> void writeToBuffer(C command) {
        if (this.commandBuffer.contains(command)) {
            return;
        }
        this.bufferCommand(command);
    }

    private <C extends RedisCommand<?, ?, T>, T> void writeToChannel(C command) {
        if (this.reliability == Reliability.AT_MOST_ONCE) {
            this.writeAndFlush(command).addListener((GenericFutureListener)new AtMostOnceWriteListener(command, this.queuedCommands));
        }
        if (this.reliability == Reliability.AT_LEAST_ONCE) {
            this.writeAndFlush(command).addListener((GenericFutureListener)new RetryListener(command));
        }
    }

    protected void bufferCommand(RedisCommand<?, ?, ?> command) {
        if (this.debugEnabled) {
            logger.debug("{} write() buffering command {}", (Object)this.logPrefix(), command);
        }
        if (this.connectionError != null) {
            if (this.debugEnabled) {
                logger.debug("{} writeToBuffer() Completing command {} due to connection error", (Object)this.logPrefix(), command);
            }
            command.completeExceptionally(this.connectionError);
            return;
        }
        this.commandBuffer.add(command);
    }

    private boolean isRejectCommand() {
        if (this.clientOptions == null) {
            return false;
        }
        switch (this.clientOptions.getDisconnectedBehavior()) {
            case REJECT_COMMANDS: {
                return true;
            }
            case ACCEPT_COMMANDS: {
                return false;
            }
        }
        return !this.clientOptions.isAutoReconnect();
    }

    @Override
    public void registerQueue(HasQueuedCommands queueHolder) {
        this.queuedCommands.register(queueHolder);
    }

    @Override
    public void unregisterQueue(HasQueuedCommands queueHolder) {
        this.queuedCommands.unregister(queueHolder);
    }

    @Override
    public void notifyChannelActive(Channel channel) {
        this.logPrefix = null;
        this.channel = channel;
        this.connectionError = null;
        if (this.isClosed()) {
            logger.info("{} Closing channel because endpoint is already closed", (Object)this.logPrefix());
            channel.close();
            return;
        }
        if (this.connectionWatchdog != null) {
            this.connectionWatchdog.arm();
        }
        this.sharedLock.doExclusive(() -> {
            try {
                if (this.debugEnabled) {
                    logger.debug("{} activateEndpointAndExecuteBufferedCommands {} command(s) buffered", (Object)this.logPrefix(), (Object)this.commandBuffer.size());
                }
                if (this.debugEnabled) {
                    logger.debug("{} activating endpoint", (Object)this.logPrefix());
                }
                this.connectionFacade.activated();
                this.flushCommands();
            }
            catch (Exception e) {
                if (this.debugEnabled) {
                    logger.debug("{} channelActive() ran into an exception", (Object)this.logPrefix());
                }
                if (this.clientOptions.isCancelCommandsOnReconnectFailure()) {
                    this.reset();
                }
                throw e;
            }
        });
    }

    @Override
    public void notifyChannelInactive(Channel channel) {
        if (this.isClosed()) {
            this.cancelBufferedCommands("Connection closed");
        }
        this.sharedLock.doExclusive(() -> {
            if (this.debugEnabled) {
                logger.debug("{} deactivating endpoint handler", (Object)this.logPrefix());
            }
            this.connectionFacade.deactivated();
        });
        if (this.channel == channel) {
            this.channel = null;
        }
    }

    @Override
    public void notifyException(Throwable t) {
        if (!this.isConnected()) {
            this.connectionError = t;
        }
    }

    @Override
    public void registerConnectionWatchdog(Optional<ConnectionWatchdog> connectionWatchdog) {
        this.connectionWatchdog = connectionWatchdog.orElse(null);
    }

    @Override
    public Queue<RedisCommand<?, ?, ?>> getQueue() {
        return this.commandBuffer;
    }

    @Override
    public void flushCommands() {
        if (this.debugEnabled) {
            logger.debug("{} flushCommands()", (Object)this.logPrefix());
        }
        if (this.isConnected()) {
            List commands = this.sharedLock.doExclusive(() -> {
                if (this.commandBuffer.isEmpty()) {
                    return Collections.emptyList();
                }
                return this.drainCommands(this.commandBuffer);
            });
            if (this.debugEnabled) {
                logger.debug("{} flushCommands() Flushing {} commands", (Object)this.logPrefix(), (Object)commands.size());
            }
            if (!commands.isEmpty()) {
                if (this.reliability == Reliability.AT_MOST_ONCE) {
                    this.writeAndFlush(commands).addListener((GenericFutureListener)new AtMostOnceWriteListener(commands, this.queuedCommands));
                }
                if (this.reliability == Reliability.AT_LEAST_ONCE) {
                    this.writeAndFlush(commands).addListener((GenericFutureListener)new RetryListener(commands));
                }
            }
        }
    }

    @Override
    public void close() {
        if (this.debugEnabled) {
            logger.debug("{} close()", (Object)this.logPrefix());
        }
        if (this.isClosed()) {
            return;
        }
        if (this.closed.compareAndSet(false, true)) {
            Channel currentChannel;
            if (this.connectionWatchdog != null) {
                this.connectionWatchdog.prepareClose();
            }
            if ((currentChannel = this.channel) != null) {
                ChannelFuture close = currentChannel.close();
                if (currentChannel.isOpen()) {
                    close.syncUninterruptibly();
                }
            }
        }
    }

    @Override
    public void reset() {
        if (this.debugEnabled) {
            logger.debug("{} reset()", (Object)this.logPrefix());
        }
        if (this.channel != null) {
            this.channel.pipeline().fireUserEventTriggered((Object)new ConnectionEvents.Reset());
        }
        this.cancelBufferedCommands("Reset");
    }

    @Override
    public void setConnectionFacade(ConnectionFacade connectionFacade) {
        this.connectionFacade = connectionFacade;
    }

    @Override
    public void setAutoFlushCommands(boolean autoFlush) {
        this.autoFlushCommands = autoFlush;
    }

    public void initialState() {
        this.commandBuffer.clear();
        Channel currentChannel = this.channel;
        if (currentChannel != null) {
            ChannelFuture close = currentChannel.close();
            if (currentChannel.isOpen()) {
                close.syncUninterruptibly();
            }
        }
    }

    @Override
    public void notifyDrainQueuedCommands(HasQueuedCommands queuedCommands) {
        if (this.isClosed()) {
            this.cancelCommands("Connection closed", queuedCommands.getQueue());
            return;
        }
        this.sharedLock.doExclusive(() -> {
            List<RedisCommand<?, ?, ?>> commands = this.drainCommands(queuedCommands.getQueue());
            Collections.reverse(commands);
            logger.debug("{} notifyQueuedCommands {} command(s) added to buffer", (Object)this.logPrefix(), (Object)commands.size());
            for (RedisCommand<?, ?, ?> command : commands) {
                if (this.commandBuffer.contains(command)) continue;
                this.commandBuffer.addFirst(command);
            }
            if (this.isConnected()) {
                this.flushCommands();
            }
        });
    }

    public boolean isClosed() {
        return this.closed.get();
    }

    protected <T> T doExclusive(Supplier<T> supplier) {
        return this.sharedLock.doExclusive(supplier);
    }

    private ChannelFuture writeAndFlush(List<? extends RedisCommand<?, ?, ?>> commands) {
        if (this.debugEnabled) {
            logger.debug("{} write() writeAndFlush commands {}", (Object)this.logPrefix(), commands);
        }
        return this.channel.writeAndFlush(commands);
    }

    private ChannelFuture writeAndFlush(RedisCommand<?, ?, ?> command) {
        if (this.debugEnabled) {
            logger.debug("{} write() writeAndFlush command {}", (Object)this.logPrefix(), command);
        }
        return this.channel.writeAndFlush(command);
    }

    private List<RedisCommand<?, ?, ?>> drainCommands(Queue<? extends RedisCommand<?, ?, ?>> source) {
        RedisCommand<?, ?, ?> cmd;
        ArrayList target = new ArrayList(source.size());
        while ((cmd = source.poll()) != null) {
            target.add(cmd);
        }
        return target;
    }

    private void cancelBufferedCommands(String message) {
        List toCancel = this.sharedLock.doExclusive(this.queuedCommands::drainCommands);
        this.cancelCommands(message, toCancel);
    }

    private void cancelCommands(String message, Iterable<? extends RedisCommand<?, ?, ?>> toCancel) {
        for (RedisCommand<?, ?, ?> cmd : toCancel) {
            if (cmd.getOutput() != null) {
                cmd.getOutput().setError(message);
            }
            cmd.cancel();
        }
    }

    private boolean isConnected() {
        return this.channel != null && this.channel.isActive();
    }

    protected String logPrefix() {
        if (this.logPrefix != null) {
            return this.logPrefix;
        }
        StringBuffer buffer = new StringBuffer(64);
        buffer.append('[').append("epid=0x").append(Long.toHexString(this.endpointId)).append(", ").append(ChannelLogDescriptor.logDescriptor(this.channel)).append(']');
        this.logPrefix = buffer.toString();
        return this.logPrefix;
    }

    private static enum Reliability {
        AT_MOST_ONCE,
        AT_LEAST_ONCE;

    }

    private class RetryListener
    implements GenericFutureListener<Future<Void>> {
        private final Collection<RedisCommand<?, ?, ?>> sentCommands;
        private final RedisCommand<?, ?, ?> sentCommand;

        RetryListener(Collection<RedisCommand<?, ?, ?>> sentCommands) {
            this.sentCommands = sentCommands;
            this.sentCommand = null;
        }

        RetryListener(RedisCommand<?, ?, ?> sentCommand) {
            this.sentCommands = null;
            this.sentCommand = sentCommand;
        }

        public void operationComplete(Future<Void> future) throws Exception {
            Throwable cause = future.cause();
            if (!future.isSuccess()) {
                if (this.sentCommand != null && !this.sentCommand.isCancelled() && !this.sentCommand.isDone()) {
                    DefaultEndpoint.this.write(this.sentCommand);
                }
                if (this.sentCommands != null) {
                    for (RedisCommand<?, ?, ?> command : this.sentCommands) {
                        if (command.isCancelled() || command.isDone()) continue;
                        DefaultEndpoint.this.write(command);
                    }
                }
            }
            if (!future.isSuccess() && !(cause instanceof ClosedChannelException)) {
                String message = "Unexpected exception during request: {}";
                InternalLogLevel logLevel = InternalLogLevel.WARN;
                if (cause instanceof IOException && CommandHandler.SUPPRESS_IO_EXCEPTION_MESSAGES.contains(cause.getMessage())) {
                    logLevel = InternalLogLevel.DEBUG;
                }
                logger.log(logLevel, message, (Object)cause.toString(), (Object)cause);
            }
        }
    }

    private static class AtMostOnceWriteListener
    implements ChannelFutureListener {
        private final Collection<RedisCommand<?, ?, ?>> sentCommands;
        private final RedisCommand<?, ?, ?> sentCommand;
        private final QueuedCommands queuedCommands;

        AtMostOnceWriteListener(RedisCommand<?, ?, ?> sentCommand, QueuedCommands queuedCommands) {
            this.sentCommand = sentCommand;
            this.sentCommands = null;
            this.queuedCommands = queuedCommands;
        }

        AtMostOnceWriteListener(Collection<RedisCommand<?, ?, ?>> sentCommands, QueuedCommands queuedCommands) {
            this.sentCommand = null;
            this.sentCommands = sentCommands;
            this.queuedCommands = queuedCommands;
        }

        public void operationComplete(ChannelFuture future) throws Exception {
            future.await();
            if (future.cause() != null) {
                if (this.sentCommand != null) {
                    this.sentCommand.completeExceptionally(future.cause());
                    this.queuedCommands.remove(this.sentCommand);
                }
                if (this.sentCommands != null) {
                    for (RedisCommand<?, ?, ?> sentCommand : this.sentCommands) {
                        sentCommand.completeExceptionally(future.cause());
                    }
                    this.queuedCommands.removeAll(this.sentCommands);
                }
            }
        }
    }
}

