/*
 * Decompiled with CFR 0.152.
 */
package com.lambdaworks.redis.protocol;

import com.lambdaworks.redis.ClientOptions;
import com.lambdaworks.redis.ConnectionEvents;
import com.lambdaworks.redis.internal.LettuceAssert;
import com.lambdaworks.redis.protocol.ChannelLogDescriptor;
import com.lambdaworks.redis.protocol.ConnectionFacade;
import com.lambdaworks.redis.protocol.ReconnectionHandler;
import com.lambdaworks.redis.protocol.ReconnectionListener;
import com.lambdaworks.redis.resource.Delay;
import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.util.Timeout;
import io.netty.util.Timer;
import io.netty.util.TimerTask;
import io.netty.util.concurrent.EventExecutorGroup;
import io.netty.util.internal.logging.InternalLogLevel;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.net.SocketAddress;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;

@ChannelHandler.Sharable
public class ConnectionWatchdog
extends ChannelInboundHandlerAdapter {
    private static final long LOGGING_QUIET_TIME_MS = TimeUnit.MILLISECONDS.convert(5L, TimeUnit.SECONDS);
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(ConnectionWatchdog.class);
    private final Delay reconnectDelay;
    private final Bootstrap bootstrap;
    private final EventExecutorGroup reconnectWorkers;
    private final ReconnectionHandler reconnectionHandler;
    private final ReconnectionListener reconnectionListener;
    private final Timer timer;
    private Channel channel;
    private SocketAddress remoteAddress;
    private long lastReconnectionLogging = -1L;
    private String logPrefix;
    private volatile int attempts;
    private volatile boolean armed;
    private volatile boolean listenOnChannelInactive;
    private volatile Timeout reconnectScheduleTimeout;

    public ConnectionWatchdog(Delay reconnectDelay, ClientOptions clientOptions, Bootstrap bootstrap, Timer timer, EventExecutorGroup reconnectWorkers, final Supplier<SocketAddress> socketAddressSupplier, ReconnectionListener reconnectionListener, ConnectionFacade connectionFacade) {
        LettuceAssert.notNull(reconnectDelay, "Delay must not be null");
        LettuceAssert.notNull(clientOptions, "ClientOptions must not be null");
        LettuceAssert.notNull(bootstrap, "Bootstrap must not be null");
        LettuceAssert.notNull(timer, "Timer must not be null");
        LettuceAssert.notNull(reconnectWorkers, "ReconnectWorkers must not be null");
        LettuceAssert.notNull(reconnectionListener, "ReconnectionListener must not be null");
        LettuceAssert.notNull(connectionFacade, "ConnectionFacade must not be null");
        this.reconnectDelay = reconnectDelay;
        this.bootstrap = bootstrap;
        this.timer = timer;
        this.reconnectWorkers = reconnectWorkers;
        this.reconnectionListener = reconnectionListener;
        Supplier<SocketAddress> wrappedSocketAddressSupplier = new Supplier<SocketAddress>(){

            @Override
            public SocketAddress get() {
                if (socketAddressSupplier != null) {
                    try {
                        ConnectionWatchdog.this.remoteAddress = (SocketAddress)socketAddressSupplier.get();
                    }
                    catch (RuntimeException e) {
                        logger.warn("Cannot retrieve the current address from socketAddressSupplier: " + e.toString() + ", reusing old address " + ConnectionWatchdog.this.remoteAddress);
                    }
                }
                return ConnectionWatchdog.this.remoteAddress;
            }
        };
        this.reconnectionHandler = new ReconnectionHandler(clientOptions, bootstrap, wrappedSocketAddressSupplier, connectionFacade);
        this.resetReconnectDelay();
    }

    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
        logger.debug("{} userEventTriggered(ctx, {})", (Object)this.logPrefix(), evt);
        if (evt instanceof ConnectionEvents.Activated) {
            this.attempts = 0;
            this.resetReconnectDelay();
        }
        super.userEventTriggered(ctx, evt);
    }

    void prepareClose() {
        this.setListenOnChannelInactive(false);
        this.setReconnectSuspended(true);
        this.reconnectionHandler.prepareClose();
    }

    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        this.channel = ctx.channel();
        this.reconnectScheduleTimeout = null;
        this.remoteAddress = this.channel.remoteAddress();
        this.logPrefix = null;
        logger.debug("{} channelActive()", (Object)this.logPrefix());
        super.channelActive(ctx);
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        logger.debug("{} channelInactive()", (Object)this.logPrefix());
        if (!this.armed) {
            logger.debug("{} ConnectionWatchdog not armed", (Object)this.logPrefix());
            return;
        }
        this.channel = null;
        if (this.listenOnChannelInactive && !this.reconnectionHandler.isReconnectSuspended()) {
            this.scheduleReconnect();
        } else {
            logger.debug("{} Reconnect scheduling disabled", (Object)this.logPrefix(), (Object)ctx);
        }
        super.channelInactive(ctx);
    }

    void arm() {
        this.armed = true;
        this.setListenOnChannelInactive(true);
    }

    public synchronized void scheduleReconnect() {
        logger.debug("{} scheduleReconnect()", (Object)this.logPrefix());
        if (!this.isEventLoopGroupActive()) {
            logger.debug("isEventLoopGroupActive() == false");
            return;
        }
        if (!this.isListenOnChannelInactive()) {
            logger.debug("Skip reconnect scheduling, listener disabled");
            return;
        }
        if (!(this.channel != null && this.channel.isActive() || this.reconnectScheduleTimeout != null)) {
            ++this.attempts;
            final int attempt = this.attempts;
            int timeout = (int)this.reconnectDelay.getTimeUnit().toMillis(this.reconnectDelay.createDelay(attempt));
            logger.debug("{} Reconnect attempt {}, delay {}ms", new Object[]{this.logPrefix(), attempt, timeout});
            this.reconnectScheduleTimeout = this.timer.newTimeout(new TimerTask(){

                public void run(Timeout timeout) throws Exception {
                    if (!ConnectionWatchdog.this.isEventLoopGroupActive()) {
                        logger.debug("isEventLoopGroupActive() == false");
                        return;
                    }
                    ConnectionWatchdog.this.reconnectWorkers.submit(() -> {
                        ConnectionWatchdog.this.run(attempt);
                        return null;
                    });
                }
            }, (long)timeout, TimeUnit.MILLISECONDS);
        } else {
            logger.debug("{} Skipping scheduleReconnect() because I have an active channel", (Object)this.logPrefix());
        }
    }

    public void run(int attempt) throws Exception {
        block7: {
            this.reconnectScheduleTimeout = null;
            if (!this.isEventLoopGroupActive()) {
                logger.debug("isEventLoopGroupActive() == false");
                return;
            }
            if (!this.isListenOnChannelInactive()) {
                logger.debug("Skip reconnect scheduling, listener disabled");
                return;
            }
            boolean shouldLog = this.shouldLog();
            InternalLogLevel infoLevel = InternalLogLevel.INFO;
            InternalLogLevel warnLevel = InternalLogLevel.WARN;
            if (shouldLog) {
                this.lastReconnectionLogging = System.currentTimeMillis();
            } else {
                warnLevel = InternalLogLevel.DEBUG;
                infoLevel = InternalLogLevel.DEBUG;
            }
            try {
                this.reconnectionListener.onReconnect(new ConnectionEvents.Reconnect(attempt));
                this.reconnect(infoLevel, warnLevel);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw e;
            }
            catch (Exception e) {
                logger.log(warnLevel, "Cannot connect: {}", (Object)e.toString());
                if (this.isReconnectSuspended()) break block7;
                this.scheduleReconnect();
            }
        }
    }

    protected void reconnect(InternalLogLevel infoLevel, InternalLogLevel warnLevel) throws Exception {
        logger.log(infoLevel, "Reconnecting, last destination was {}", (Object)this.remoteAddress);
        this.reconnectionHandler.reconnect(infoLevel);
    }

    private boolean isEventLoopGroupActive() {
        return this.isEventLoopGroupActive((EventExecutorGroup)this.bootstrap.group()) && this.isEventLoopGroupActive(this.reconnectWorkers);
    }

    private boolean isEventLoopGroupActive(EventExecutorGroup executorService) {
        return !executorService.isShutdown() && !executorService.isTerminated() && !executorService.isShuttingDown();
    }

    private boolean shouldLog() {
        long quietUntil = this.lastReconnectionLogging + LOGGING_QUIET_TIME_MS;
        return quietUntil <= System.currentTimeMillis();
    }

    public void setListenOnChannelInactive(boolean listenOnChannelInactive) {
        this.listenOnChannelInactive = listenOnChannelInactive;
    }

    public boolean isListenOnChannelInactive() {
        return this.listenOnChannelInactive;
    }

    public void setReconnectSuspended(boolean reconnectSuspended) {
        this.reconnectionHandler.setReconnectSuspended(reconnectSuspended);
    }

    public boolean isReconnectSuspended() {
        return this.reconnectionHandler.isReconnectSuspended();
    }

    ReconnectionHandler getReconnectionHandler() {
        return this.reconnectionHandler;
    }

    private void resetReconnectDelay() {
        if (this.reconnectDelay instanceof Delay.StatefulDelay) {
            ((Delay.StatefulDelay)((Object)this.reconnectDelay)).reset();
        }
    }

    private String logPrefix() {
        if (this.logPrefix != null) {
            return this.logPrefix;
        }
        StringBuilder buffer = new StringBuilder(64);
        buffer.append('[').append("Last known addr=").append(this.remoteAddress).append(", ").append(ChannelLogDescriptor.logDescriptor(this.channel)).append(']');
        this.logPrefix = buffer.toString();
        return this.logPrefix;
    }
}

