/*
 * Decompiled with CFR 0.152.
 */
package com.lambdaworks.redis.protocol;

import com.lambdaworks.redis.internal.LettuceAssert;
import com.lambdaworks.redis.output.CommandOutput;
import com.lambdaworks.redis.protocol.CommandArgs;
import com.lambdaworks.redis.protocol.ProtocolKeyword;
import com.lambdaworks.redis.protocol.RedisCommand;
import com.lambdaworks.redis.protocol.WithLatency;
import io.netty.buffer.ByteBuf;

public class Command<K, V, T>
implements RedisCommand<K, V, T>,
WithLatency {
    private final ProtocolKeyword type;
    protected CommandArgs<K, V> args;
    protected CommandOutput<K, V, T> output;
    protected Throwable exception;
    protected boolean cancelled = false;
    protected boolean completed = false;
    protected long sentNs = -1L;
    protected long firstResponseNs = -1L;
    protected long completedNs = -1L;

    public Command(ProtocolKeyword type, CommandOutput<K, V, T> output) {
        this(type, output, null);
    }

    public Command(ProtocolKeyword type, CommandOutput<K, V, T> output, CommandArgs<K, V> args) {
        LettuceAssert.notNull(type, "Command type must not be null");
        this.type = type;
        this.output = output;
        this.args = args;
    }

    @Override
    public CommandOutput<K, V, T> getOutput() {
        return this.output;
    }

    @Override
    public boolean completeExceptionally(Throwable throwable) {
        if (this.output != null) {
            this.output.setError(throwable.getMessage());
        }
        this.exception = throwable;
        return true;
    }

    @Override
    public void complete() {
        this.completed = true;
    }

    @Override
    public void cancel() {
        this.cancelled = true;
    }

    @Override
    public void encode(ByteBuf buf) {
        buf.writeByte(42);
        CommandArgs.IntegerArgument.writeInteger(buf, 1 + (this.args != null ? this.args.count() : 0));
        buf.writeBytes(CommandArgs.CRLF);
        CommandArgs.BytesArgument.writeBytes(buf, this.type.getBytes());
        if (this.args != null) {
            this.args.encode(buf);
        }
    }

    public String getError() {
        return this.output.getError();
    }

    @Override
    public CommandArgs<K, V> getArgs() {
        return this.args;
    }

    public T get() {
        if (this.output != null) {
            return this.output.get();
        }
        return null;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName());
        sb.append(" [type=").append(this.type);
        sb.append(", output=").append(this.output);
        sb.append(']');
        return sb.toString();
    }

    @Override
    public void setOutput(CommandOutput<K, V, T> output) {
        if (this.isCancelled() || this.completed) {
            throw new IllegalStateException("Command is completed/cancelled. Cannot set a new output");
        }
        this.output = output;
    }

    @Override
    public ProtocolKeyword getType() {
        return this.type;
    }

    @Override
    public boolean isCancelled() {
        return this.cancelled;
    }

    @Override
    public boolean isDone() {
        return this.completed;
    }

    @Override
    public void sent(long timeNs) {
        this.sentNs = timeNs;
        this.firstResponseNs = -1L;
        this.completedNs = -1L;
    }

    @Override
    public void firstResponse(long timeNs) {
        this.firstResponseNs = timeNs;
    }

    @Override
    public void completed(long timeNs) {
        this.completedNs = timeNs;
    }

    @Override
    public long getSent() {
        return this.sentNs;
    }

    @Override
    public long getFirstResponse() {
        return this.firstResponseNs;
    }

    @Override
    public long getCompleted() {
        return this.completedNs;
    }
}

