/*
 * Decompiled with CFR 0.152.
 */
package com.lambdaworks.redis.masterslave;

import com.lambdaworks.redis.RedisURI;
import com.lambdaworks.redis.codec.Utf8StringCodec;
import com.lambdaworks.redis.models.role.RedisNodeDescription;
import java.util.Collection;

class MasterSlaveUtils {
    static final Utf8StringCodec CODEC = new Utf8StringCodec();

    MasterSlaveUtils() {
    }

    static boolean isChanged(Collection<RedisNodeDescription> o1, Collection<RedisNodeDescription> o2) {
        if (o1.size() != o2.size()) {
            return true;
        }
        for (RedisNodeDescription base : o2) {
            if (MasterSlaveUtils.essentiallyEqualsTo(base, MasterSlaveUtils.findNodeByUri(o1, base.getUri()))) continue;
            return true;
        }
        return false;
    }

    static RedisNodeDescription findNodeByUri(Collection<RedisNodeDescription> nodes, RedisURI lookupUri) {
        return MasterSlaveUtils.findNodeByHostAndPort(nodes, lookupUri.getHost(), lookupUri.getPort());
    }

    static RedisNodeDescription findNodeByHostAndPort(Collection<RedisNodeDescription> nodes, String host, int port) {
        for (RedisNodeDescription node : nodes) {
            RedisURI nodeUri = node.getUri();
            if (!nodeUri.getHost().equals(host) || nodeUri.getPort() != port) continue;
            return node;
        }
        return null;
    }

    static boolean essentiallyEqualsTo(RedisNodeDescription o1, RedisNodeDescription o2) {
        if (o2 == null) {
            return false;
        }
        if (o1.getRole() != o2.getRole()) {
            return false;
        }
        return o1.getUri().equals(o2.getUri());
    }
}

