/*
 * Decompiled with CFR 0.152.
 */
package com.lambdaworks.redis.masterslave;

import com.lambdaworks.redis.ReadFrom;
import com.lambdaworks.redis.RedisChannelWriter;
import com.lambdaworks.redis.RedisException;
import com.lambdaworks.redis.api.StatefulRedisConnection;
import com.lambdaworks.redis.internal.LettuceAssert;
import com.lambdaworks.redis.masterslave.MasterSlaveConnectionProvider;
import com.lambdaworks.redis.masterslave.ReadOnlyCommands;
import com.lambdaworks.redis.protocol.ConnectionFacade;
import com.lambdaworks.redis.protocol.ProtocolKeyword;
import com.lambdaworks.redis.protocol.RedisCommand;

class MasterSlaveChannelWriter<K, V>
implements RedisChannelWriter {
    private MasterSlaveConnectionProvider<K, V> masterSlaveConnectionProvider;
    private boolean closed = false;

    public MasterSlaveChannelWriter(MasterSlaveConnectionProvider<K, V> masterSlaveConnectionProvider) {
        this.masterSlaveConnectionProvider = masterSlaveConnectionProvider;
    }

    @Override
    public <K, V, T> RedisCommand<K, V, T> write(RedisCommand<K, V, T> command) {
        LettuceAssert.notNull(command, "Command must not be null");
        if (this.closed) {
            throw new RedisException("Connection is closed");
        }
        MasterSlaveConnectionProvider.Intent intent = this.getIntent(command.getType());
        StatefulRedisConnection<K, V> connection = this.masterSlaveConnectionProvider.getConnection(intent);
        return connection.dispatch(command);
    }

    private MasterSlaveConnectionProvider.Intent getIntent(ProtocolKeyword type) {
        for (ProtocolKeyword readOnlyCommand : ReadOnlyCommands.READ_ONLY_COMMANDS) {
            if (readOnlyCommand != type) continue;
            return MasterSlaveConnectionProvider.Intent.READ;
        }
        return MasterSlaveConnectionProvider.Intent.WRITE;
    }

    @Override
    public void close() {
        if (this.closed) {
            return;
        }
        this.closed = true;
        if (this.masterSlaveConnectionProvider != null) {
            this.masterSlaveConnectionProvider.close();
            this.masterSlaveConnectionProvider = null;
        }
    }

    public MasterSlaveConnectionProvider getMasterSlaveConnectionProvider() {
        return this.masterSlaveConnectionProvider;
    }

    @Override
    public void setConnectionFacade(ConnectionFacade connection) {
    }

    @Override
    public void setAutoFlushCommands(boolean autoFlush) {
        this.masterSlaveConnectionProvider.setAutoFlushCommands(autoFlush);
    }

    @Override
    public void flushCommands() {
        this.masterSlaveConnectionProvider.flushCommands();
    }

    @Override
    public void reset() {
        this.masterSlaveConnectionProvider.reset();
    }

    public void setReadFrom(ReadFrom readFrom) {
        this.masterSlaveConnectionProvider.setReadFrom(readFrom);
    }

    public ReadFrom getReadFrom() {
        return this.masterSlaveConnectionProvider.getReadFrom();
    }
}

