/*
 * Decompiled with CFR 0.152.
 */
package com.lambdaworks.redis.dynamic.parameter;

import com.lambdaworks.redis.dynamic.support.AnnotationParameterNameDiscoverer;
import com.lambdaworks.redis.dynamic.support.ClassTypeInformation;
import com.lambdaworks.redis.dynamic.support.CompositeParameterNameDiscoverer;
import com.lambdaworks.redis.dynamic.support.MethodParameter;
import com.lambdaworks.redis.dynamic.support.ParameterNameDiscoverer;
import com.lambdaworks.redis.dynamic.support.StandardReflectionParameterNameDiscoverer;
import com.lambdaworks.redis.dynamic.support.TypeInformation;
import com.lambdaworks.redis.internal.LettuceAssert;
import com.lambdaworks.redis.internal.LettuceClassUtils;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class Parameter {
    private final ParameterNameDiscoverer discoverer = new CompositeParameterNameDiscoverer(new StandardReflectionParameterNameDiscoverer(), new AnnotationParameterNameDiscoverer());
    private final Method method;
    private final String name;
    private final int parameterIndex;
    private final TypeInformation<?> typeInformation;
    private final MethodParameter methodParameter;

    public Parameter(Method method, int parameterIndex) {
        this.method = method;
        this.parameterIndex = parameterIndex;
        this.methodParameter = new MethodParameter(method, parameterIndex);
        this.methodParameter.initParameterNameDiscovery(this.discoverer);
        this.name = this.methodParameter.getParameterName();
        this.typeInformation = ClassTypeInformation.fromMethodParameter(method, parameterIndex);
    }

    public <A extends Annotation> A findAnnotation(Class<A> annotationType) {
        return this.methodParameter.getParameterAnnotation(annotationType);
    }

    public List<? extends Annotation> getAnnotations() {
        Annotation[] annotations = this.method.getParameterAnnotations()[this.parameterIndex];
        ArrayList result = new ArrayList(annotations.length);
        Collections.addAll(result, annotations);
        return result;
    }

    public int getParameterIndex() {
        return this.parameterIndex;
    }

    public Class<?> getParameterType() {
        return this.method.getParameterTypes()[this.parameterIndex];
    }

    public TypeInformation<?> getTypeInformation() {
        return this.typeInformation;
    }

    public boolean isAssignableTo(Class<?> target) {
        LettuceAssert.notNull(target, "Target type must not be null");
        return LettuceClassUtils.isAssignable(target, this.getParameterType());
    }

    public boolean isSpecialParameter() {
        return false;
    }

    boolean isBindable() {
        return !this.isSpecialParameter();
    }

    public String getName() {
        return this.name;
    }
}

