/*
 * Decompiled with CFR 0.152.
 */
package com.lambdaworks.redis.dynamic.parameter;

import com.lambdaworks.redis.dynamic.domain.Timeout;
import com.lambdaworks.redis.dynamic.parameter.Parameter;
import com.lambdaworks.redis.dynamic.parameter.Parameters;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;

public class ExecutionSpecificParameters
extends Parameters<ExecutionAwareParameter> {
    private static final List<Class<?>> TYPES = Arrays.asList(Timeout.class);
    private final int timeoutIndex;

    public ExecutionSpecificParameters(Method method) {
        super(method);
        int timeoutIndex = -1;
        List parameters = this.getParameters();
        for (int i = 0; i < method.getParameterCount(); ++i) {
            Parameter methodParameter = (Parameter)parameters.get(i);
            if (!methodParameter.isSpecialParameter() || !methodParameter.isAssignableTo(Timeout.class)) continue;
            timeoutIndex = i;
        }
        this.timeoutIndex = timeoutIndex;
    }

    public int getTimeoutIndex() {
        return this.timeoutIndex;
    }

    @Override
    protected ExecutionAwareParameter createParameter(Method method, int parameterIndex) {
        return new ExecutionAwareParameter(method, parameterIndex);
    }

    public boolean hasTimeoutIndex() {
        return this.getTimeoutIndex() != -1;
    }

    public static class ExecutionAwareParameter
    extends Parameter {
        public ExecutionAwareParameter(Method method, int parameterIndex) {
            super(method, parameterIndex);
        }

        @Override
        public boolean isSpecialParameter() {
            return super.isSpecialParameter() || TYPES.contains(this.getParameterType());
        }
    }
}

