/*
 * Decompiled with CFR 0.152.
 */
package com.lambdaworks.redis.dynamic.output;

import com.lambdaworks.redis.dynamic.support.TypeInformation;
import com.lambdaworks.redis.internal.LettuceAssert;
import com.lambdaworks.redis.output.CommandOutput;

public class OutputType {
    private final Class<?> primaryType;
    private final Class<? extends CommandOutput> commandOutputClass;
    private final TypeInformation<?> typeInformation;
    private final boolean streaming;

    public OutputType(Class<?> primaryType, Class<? extends CommandOutput> commandOutputClass, TypeInformation<?> typeInformation, boolean streaming) {
        LettuceAssert.notNull(primaryType, "Primary type must not be null");
        LettuceAssert.notNull(commandOutputClass, "CommandOutput class must not be null");
        LettuceAssert.notNull(typeInformation, "TypeInformation must not be null");
        this.primaryType = primaryType;
        this.commandOutputClass = commandOutputClass;
        this.typeInformation = typeInformation;
        this.streaming = streaming;
    }

    public Class<?> getPrimaryType() {
        return this.primaryType;
    }

    public TypeInformation<?> getTypeInformation() {
        return this.typeInformation;
    }

    public boolean isStreaming() {
        return this.streaming;
    }

    public Class<?> getCommandOutputClass() {
        return this.commandOutputClass;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName());
        sb.append(" [primaryType=").append(this.primaryType);
        sb.append(", commandOutputClass=").append(this.commandOutputClass);
        sb.append(", typeInformation=").append(this.typeInformation);
        sb.append(", streaming=").append(this.streaming);
        sb.append(']');
        return sb.toString();
    }
}

